/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import src.backend.ObjsEntry;
import src.backend.StaticFunctions;
import src.gui.Model;
import src.gui.ObjsChangeFrame;
import src.gui.ObjsFlagsFrame;
import src.gui.ObjsTableModel;

public class ObjsFrame
extends JFrame {
    private String[] columnNames = new String[]{"Type", "Subtype", "Facing/volume", "Polygon", "x", "y", "z"};
    private Model model;
    private int levelIndex;
    private JTable table;
    private JScrollPane scroller;
    private ObjsTableModel tableModel;
    private ObjsEntry bufferedEntry;
    private ObjsEntry duplicatedEntry;
    private boolean hasBuffered;
    private int clickCount;
    JMenuBar mnuBar = new JMenuBar();
    JMenu mnuCommands = new JMenu();
    JMenuItem mnuCommandsCopy = new JMenuItem();
    JMenuItem mnuCommandsPaste = new JMenuItem();
    JMenuItem mnuCommandsDuplicate = new JMenuItem();
    JMenuItem mnuCommandsEditFlags = new JMenuItem();
    JMenuItem mnuCommandsCenterObject = new JMenuItem();
    JMenuItem mnuCommandsAdd = new JMenuItem();
    JMenuItem mnuCommandsRemove = new JMenuItem();
    JMenuItem mnuCommandsZeroZs = new JMenuItem();
    JMenuItem mnuCommandsZByType = new JMenuItem();
    JMenuItem mnuCommandsZBySubtype = new JMenuItem();
    JMenuItem mnuCommandsChangeAll = new JMenuItem();

    public ObjsFrame(Model model, int levelIndex) {
        this.model = model;
        this.levelIndex = levelIndex;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.tableModel = new ObjsTableModel(this.columnNames, this.model, this.levelIndex);
        this.tableModel.addTableModelListener(new ObjsTableModelListener());
        this.table = new JTable(this.tableModel);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.updateComboBoxes();
        this.scroller = new JScrollPane(this.table);
        this.table.getTableHeader().addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent m) {
            }

            public void mouseEntered(MouseEvent m) {
            }

            public void mouseReleased(MouseEvent m) {
            }

            public void mousePressed(MouseEvent m) {
            }

            public void mouseClicked(MouseEvent m) {
                Point mousePoint = new Point(m.getX(), m.getY());
                int header = ObjsFrame.this.table.getTableHeader().columnAtPoint(mousePoint);
                ObjsFrame objsFrame = ObjsFrame.this;
                objsFrame.clickCount = objsFrame.clickCount + 1;
                boolean reverseOrder = false;
                if (ObjsFrame.this.clickCount % 2 == 0) {
                    reverseOrder = true;
                }
                ObjsFrame.this.tableModel.sort(header, reverseOrder);
            }
        });
        this.getContentPane().add(this.scroller);
        this.clickCount = 0;
        this.setJMenuBar(this.mnuBar);
        this.mnuCommands.setText("Commands");
        this.mnuCommandsCopy.setText("Copy (ctrl+c)");
        this.mnuCommandsCopy.addActionListener(new ObjsFrame_mnuCommandsCopy_actionAdapter(this));
        this.mnuCommandsPaste.setText("Paste (ctrl+v)");
        this.mnuCommandsPaste.addActionListener(new ObjsFrame_mnuCommandsPaste_actionAdapter(this));
        this.mnuCommandsDuplicate.setText("Duplicate (ctrl+d)");
        this.mnuCommandsDuplicate.addActionListener(new ObjsFrame_mnuCommandsDuplicate_actionAdapter(this));
        this.mnuCommandsEditFlags.setText("Edit Flags");
        this.mnuCommandsEditFlags.addActionListener(new ObjsFrame_mnuCommandsEditFlags_actionAdapter(this));
        this.mnuCommandsCenterObject.setText("Center in polygon (alt+c)");
        this.mnuCommandsCenterObject.addActionListener(new ObjsFrame_mnuCommandsCenterObject_actionAdapter(this));
        this.mnuCommandsAdd.setText("Add object (ctrl+n)");
        this.mnuCommandsAdd.addActionListener(new ObjsFrame_mnuCommandsAdd_actionAdapter(this));
        this.mnuCommandsRemove.setText("Remove object (delete)");
        this.mnuCommandsRemove.addActionListener(new ObjsFrame_mnuCommandsRemove_actionAdapter(this));
        this.mnuCommandsZeroZs.setText("Set all Zs to 0 (alt+z)");
        this.mnuCommandsZeroZs.addActionListener(new ObjsFrame_mnuCommandsZeroZs_actionAdapter(this));
        this.mnuCommandsZByType.setText("Set all Z by type");
        this.mnuCommandsZByType.addActionListener(new ObjsFrame_mnuCommandsZByType_actionAdapter(this));
        this.mnuCommandsZBySubtype.setText("Set all Z by subtype");
        this.mnuCommandsZBySubtype.addActionListener(new ObjsFrame_mnuCommandsZBySubtype_actionAdapter(this));
        this.mnuCommandsChangeAll.setText("Change all ...");
        this.mnuCommandsChangeAll.addActionListener(new ObjsFrame_mnuCommandsChangeAll_actionAdapter(this));
        this.mnuBar.add(this.mnuCommands);
        this.mnuCommands.add(this.mnuCommandsCopy);
        this.mnuCommands.add(this.mnuCommandsPaste);
        this.mnuCommands.add(this.mnuCommandsDuplicate);
        this.mnuCommands.add(this.mnuCommandsCenterObject);
        this.mnuCommands.add(this.mnuCommandsAdd);
        this.mnuCommands.add(this.mnuCommandsRemove);
        this.mnuCommands.add(this.mnuCommandsZeroZs);
        this.mnuCommands.add(this.mnuCommandsZByType);
        this.mnuCommands.add(this.mnuCommandsZBySubtype);
        this.mnuCommands.add(this.mnuCommandsEditFlags);
        this.mnuCommands.add(this.mnuCommandsChangeAll);
        this.bufferedEntry = new ObjsEntry(this.model.getObjsChunk(this.levelIndex));
        this.duplicatedEntry = new ObjsEntry(this.model.getObjsChunk(this.levelIndex));
        this.hasBuffered = false;
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 67 && e.isAltDown()) {
                    ObjsFrame.this.centerObject();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 78 && e.isControlDown()) {
                    ObjsFrame.this.addObject();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ObjsFrame.this.removeObject();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 67 && e.isControlDown()) {
                    ObjsFrame.this.copyObject();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 86 && e.isControlDown()) {
                    ObjsFrame.this.pasteObject();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 68 && e.isControlDown()) {
                    ObjsFrame.this.duplicateObject();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 90 && e.isAltDown()) {
                    ObjsFrame.this.zeroZs();
                }
            }
        });
        this.addWindowListener(new WindowListener(){

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                ObjsFrame.this.closeTable();
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        this.setSize(525, 440);
        this.setTitle("Objects - " + this.model.getLevelSelectName());
        StaticFunctions.centerFrame(this);
        this.setVisible(true);
    }

    public void updateComboBoxes() {
        TableColumn typeCol = this.table.getColumnModel().getColumn(0);
        TableColumn subTypeCol = this.table.getColumnModel().getColumn(1);
        JComboBox<String> typeBox = new JComboBox<String>();
        int i = 0;
        while (i < StaticFunctions.OBJS_TYPES.length - 1) {
            typeBox.addItem(StaticFunctions.OBJS_TYPES[i]);
            ++i;
        }
        typeCol.setCellEditor(new DefaultCellEditor(typeBox));
        subTypeCol.setCellEditor(new DynamicCellEditor());
    }

    private void closeTable() {
        this.model.removeChildFrame(this);
    }

    private void copyObject() {
        try {
            this.hasBuffered = true;
            ObjsEntry from = (ObjsEntry)this.tableModel.getData().get(this.table.getSelectedRow());
            this.bufferedEntry.setType(from.getType());
            this.bufferedEntry.setSubtype(from.getSubtype());
            this.bufferedEntry.setFacing(from.getFacing());
        }
        catch (Exception e) {
            return;
        }
    }

    private void pasteObject() {
        try {
            int row;
            if (this.hasBuffered) {
                row = this.table.getSelectedRow();
                if (this.bufferedEntry.getType() == 5) {
                    return;
                }
            } else {
                return;
            }
            ((ObjsEntry)this.tableModel.getData().get(row)).setType(this.bufferedEntry.getType());
            ((ObjsEntry)this.tableModel.getData().get(row)).setSubtype(this.bufferedEntry.getSubtype());
            ((ObjsEntry)this.tableModel.getData().get(row)).setFacing(this.bufferedEntry.getFacing());
            this.tableModel.fireTableRowsUpdated(row, row);
        }
        catch (Exception e) {
            return;
        }
    }

    private void duplicateObject() {
        try {
            this.duplicatedEntry = new ObjsEntry(this.model.getObjsChunk(this.levelIndex));
            int row = this.table.getSelectedRow();
            if (((ObjsEntry)this.tableModel.getData().get(row)).getType() == 5) {
                return;
            }
            this.duplicatedEntry.setType(((ObjsEntry)this.tableModel.getData().get(row)).getType());
            this.duplicatedEntry.setSubtype(((ObjsEntry)this.tableModel.getData().get(row)).getSubtype());
            this.duplicatedEntry.setFacing(((ObjsEntry)this.tableModel.getData().get(row)).getFacing());
            this.duplicatedEntry.setPolygon(((ObjsEntry)this.tableModel.getData().get(row)).getPolygon());
            this.duplicatedEntry.setX(((ObjsEntry)this.tableModel.getData().get(row)).getX());
            this.duplicatedEntry.setY(((ObjsEntry)this.tableModel.getData().get(row)).getY());
            this.duplicatedEntry.setZ(((ObjsEntry)this.tableModel.getData().get(row)).getZ());
            this.model.addObject(this.levelIndex, this.duplicatedEntry);
            this.tableModel.loadTable();
        }
        catch (Exception e) {
            return;
        }
    }

    private void zeroZs() {
        try {
            int i = 0;
            while (i < this.tableModel.getData().size()) {
                ((ObjsEntry)this.tableModel.getData().get(i)).setZ(0.0);
                this.tableModel.fireTableCellUpdated(i, 6);
                ++i;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void ZByType() {
        try {
            short type = ((ObjsEntry)this.tableModel.getData().get(this.table.getSelectedRow())).getType();
            double z = ((ObjsEntry)this.tableModel.getData().get(this.table.getSelectedRow())).getZ();
            int i = 0;
            while (i < this.tableModel.getData().size()) {
                if (((ObjsEntry)this.tableModel.getData().get(i)).getType() == type) {
                    ((ObjsEntry)this.tableModel.getData().get(i)).setZ(z);
                }
                ++i;
            }
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception e) {
            return;
        }
    }

    private void ZBySubtype() {
        try {
            short subtype = ((ObjsEntry)this.tableModel.getData().get(this.table.getSelectedRow())).getSubtype();
            short type = ((ObjsEntry)this.tableModel.getData().get(this.table.getSelectedRow())).getType();
            double z = ((ObjsEntry)this.tableModel.getData().get(this.table.getSelectedRow())).getZ();
            int i = 0;
            while (i < this.tableModel.getData().size()) {
                if (((ObjsEntry)this.tableModel.getData().get(i)).getSubtype() == subtype && ((ObjsEntry)this.tableModel.getData().get(i)).getType() == type) {
                    ((ObjsEntry)this.tableModel.getData().get(i)).setZ(z);
                }
                ++i;
            }
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception e) {
            return;
        }
    }

    private void removeObject() {
        try {
            this.tableModel.removeEntry(this.table.getSelectedRow());
            this.tableModel.fireTableRowsDeleted(this.table.getSelectedRow(), this.table.getSelectedRow());
        }
        catch (Exception e) {
            return;
        }
    }

    private void addObject() {
        try {
            ObjsEntry newEntry = this.model.addObject(this.levelIndex);
            this.tableModel.addEntry(newEntry);
            this.updateComboBoxes();
            this.tableModel.fireTableRowsInserted(this.tableModel.getData().size(), this.tableModel.getData().size());
        }
        catch (Exception e) {
            return;
        }
    }

    private void showFlagsFrame() {
        try {
            ArrayList data = this.tableModel.getData();
            ObjsFlagsFrame objFF = new ObjsFlagsFrame(this.model, this.levelIndex, (ObjsEntry)data.get(this.table.getSelectedRow()));
            this.model.addChildFrame(objFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void centerObject() {
        try {
            ArrayList theData = this.tableModel.getData();
            int row = this.table.getSelectedRow();
            double dblX = this.model.getPolygonCenterX(this.levelIndex, ((ObjsEntry)theData.get(row)).getPolygon());
            double dblY = this.model.getPolygonCenterY(this.levelIndex, ((ObjsEntry)theData.get(row)).getPolygon());
            String strX = String.valueOf(dblX);
            String strY = String.valueOf(dblY);
            this.tableModel.setValueAt(strX, row, 4);
            this.tableModel.setValueAt(strY, row, 5);
            this.tableModel.fireTableCellUpdated(row, 4);
            this.tableModel.fireTableCellUpdated(row, 5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mnuCommandsEditFlags_actionPerformed(ActionEvent e) {
        this.showFlagsFrame();
    }

    public void mnuCommandsCenterObject_actionPerformed(ActionEvent e) {
        this.centerObject();
    }

    public void mnuCommandsAdd_actionPerformed(ActionEvent e) {
        this.addObject();
    }

    public void mnuCommandsRemove_actionPerformed(ActionEvent e) {
        this.removeObject();
    }

    public void mnuCommandsCopy_actionPerformed(ActionEvent e) {
        this.copyObject();
    }

    public void mnuCommandsPaste_actionPerformed(ActionEvent e) {
        this.pasteObject();
    }

    public void mnuCommandsDuplicate_actionPerformed(ActionEvent e) {
        this.duplicateObject();
    }

    public void mnuCommandsZeroZs_actionPerformed(ActionEvent e) {
        this.zeroZs();
    }

    public void mnuCommandsZByType_actionPerformed(ActionEvent e) {
        this.ZByType();
    }

    public void mnuCommandsZBySubtype_actionPerformed(ActionEvent e) {
        this.ZBySubtype();
    }

    public void mnuCommandsChangeAll_actionPerformed(ActionEvent e) {
        ObjsChangeFrame ch = new ObjsChangeFrame(this.model, this.table, this.tableModel, this.levelIndex);
        this.model.addChildFrame(ch);
    }

    public class DynamicCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox dynamicBox = new JComboBox();

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            block9: {
                String type;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    type = "";
                                    try {
                                        type = (String)table.getValueAt(row, column - 1);
                                    }
                                    catch (Exception e) {
                                        System.out.println(e);
                                    }
                                    if (!type.equals("Monster")) break block8;
                                    this.dynamicBox = new JComboBox();
                                    int i = 0;
                                    while (i < StaticFunctions.OBJS_SUBTYPES[0].length) {
                                        this.dynamicBox.addItem(StaticFunctions.OBJS_SUBTYPES[0][i]);
                                        ++i;
                                    }
                                    break block9;
                                }
                                if (!type.equals("Scenery")) break block10;
                                this.dynamicBox = new JComboBox();
                                int i = 0;
                                while (i < StaticFunctions.scenery.length) {
                                    this.dynamicBox.addItem(StaticFunctions.scenery[i]);
                                    ++i;
                                }
                                break block9;
                            }
                            if (!type.equals("Item")) break block11;
                            this.dynamicBox = new JComboBox();
                            int i = 0;
                            while (i < StaticFunctions.OBJS_SUBTYPES[2].length) {
                                this.dynamicBox.addItem(StaticFunctions.OBJS_SUBTYPES[2][i]);
                                ++i;
                            }
                            break block9;
                        }
                        if (!type.equals("Player")) break block12;
                        this.dynamicBox = new JComboBox();
                        int i = 0;
                        while (i < StaticFunctions.OBJS_SUBTYPES[3].length) {
                            this.dynamicBox.addItem(StaticFunctions.OBJS_SUBTYPES[3][i]);
                            ++i;
                        }
                        break block9;
                    }
                    if (!type.equals("Goal")) break block13;
                    this.dynamicBox = new JComboBox();
                    int i = 0;
                    while (i < StaticFunctions.OBJS_SUBTYPES[4].length) {
                        this.dynamicBox.addItem(StaticFunctions.OBJS_SUBTYPES[4][i]);
                        ++i;
                    }
                    break block9;
                }
                if (!type.equals("Sound")) break block9;
                this.dynamicBox = new JComboBox();
                int i = 0;
                while (i < StaticFunctions.OBJS_SUBTYPES[5].length) {
                    this.dynamicBox.addItem(StaticFunctions.OBJS_SUBTYPES[5][i]);
                    ++i;
                }
            }
            return this.dynamicBox;
        }

        public Object getCellEditorValue() {
            return (String)this.dynamicBox.getSelectedItem();
        }
    }

    class ObjsFrame_mnuCommandsCopy_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsCopy_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsCopy_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsPaste_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsPaste_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsPaste_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsDuplicate_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsDuplicate_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsDuplicate_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsEditFlags_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsEditFlags_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsEditFlags_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsCenterObject_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsCenterObject_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsCenterObject_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsAdd_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsAdd_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsAdd_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsRemove_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsRemove_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsRemove_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsZeroZs_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsZeroZs_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsZeroZs_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsZByType_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsZByType_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsZByType_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsZBySubtype_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsZBySubtype_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsZBySubtype_actionPerformed(e);
        }
    }

    class ObjsFrame_mnuCommandsChangeAll_actionAdapter
    implements ActionListener {
        private ObjsFrame adaptee;

        ObjsFrame_mnuCommandsChangeAll_actionAdapter(ObjsFrame adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.mnuCommandsChangeAll_actionPerformed(e);
        }
    }

    class ObjsTableModelListener
    implements TableModelListener {
        ObjsTableModelListener() {
        }

        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 0) {
                int row = evt.getFirstRow();
                try {
                    ObjsFrame.this.table.setRowSelectionInterval(row, row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

