/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import src.backend.ObjsEntry;
import src.backend.StaticFunctions;
import src.gui.Model;
import src.gui.ObjsFlagsFrame_chkBlind_actionAdapter;
import src.gui.ObjsFlagsFrame_chkDeaf_actionAdapter;
import src.gui.ObjsFlagsFrame_chkFloats_actionAdapter;
import src.gui.ObjsFlagsFrame_chkFromCeiling_actionAdapter;
import src.gui.ObjsFlagsFrame_chkNetworkOnly_actionAdapter;
import src.gui.ObjsFlagsFrame_chkPlatformSound_actionAdapter;
import src.gui.ObjsFlagsFrame_chkTeleportIn_actionAdapter;
import src.gui.ObjsFlagsFrame_jButton1_actionAdapter;

public class ObjsFlagsFrame
extends JFrame {
    private final int MONSTER = 0;
    private final int SCENERY = 1;
    private final int ITEM = 2;
    private final int PLAYER = 3;
    private final int GOAL = 4;
    private final int SOUND = 5;
    private final int teleportIn = 1;
    private final int platformSound = 1;
    private final int fromCeiling = 2;
    private final int isBlind = 4;
    private final int isDeaf = 8;
    private final int floats = 16;
    private final int networkOnly = 32;
    private final int not_teleportIn = 65534;
    private final int not_platformSound = 65534;
    private final int not_fromCeiling = 65533;
    private final int not_isBlind = 65531;
    private final int not_isDeaf = 65527;
    private final int not_floats = 65519;
    private final int not_networkOnly = 65503;
    private Model model;
    private ObjsEntry entry;
    JCheckBox chkFromCeiling = new JCheckBox();
    JCheckBox chkFloats = new JCheckBox();
    JCheckBox chkTeleportIn = new JCheckBox();
    JCheckBox chkDeaf = new JCheckBox();
    JCheckBox chkPlatformSound = new JCheckBox();
    JCheckBox chkBlind = new JCheckBox();
    JCheckBox chkNetworkOnly = new JCheckBox();
    JButton jButton1 = new JButton();

    public ObjsFlagsFrame(Model model, int levelIndex, ObjsEntry entry) {
        this.model = model;
        this.entry = entry;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.chkFromCeiling.setText("From Ceiling");
        this.chkFromCeiling.setBounds(new Rectangle(8, 47, 222, 23));
        this.chkFromCeiling.addActionListener(new ObjsFlagsFrame_chkFromCeiling_actionAdapter(this));
        this.chkNetworkOnly.setText("Network Only");
        this.chkNetworkOnly.setBounds(new Rectangle(8, 123, 139, 23));
        this.chkNetworkOnly.addActionListener(new ObjsFlagsFrame_chkNetworkOnly_actionAdapter(this));
        this.chkBlind.setText("Is blind");
        this.chkBlind.setBounds(new Rectangle(8, 66, 179, 23));
        this.chkBlind.addActionListener(new ObjsFlagsFrame_chkBlind_actionAdapter(this));
        this.chkPlatformSound.setText("Is platform sound");
        this.chkPlatformSound.setBounds(new Rectangle(8, 28, 167, 23));
        this.chkPlatformSound.addActionListener(new ObjsFlagsFrame_chkPlatformSound_actionAdapter(this));
        this.chkDeaf.setText("Is deaf");
        this.chkDeaf.setBounds(new Rectangle(8, 85, 184, 23));
        this.chkDeaf.addActionListener(new ObjsFlagsFrame_chkDeaf_actionAdapter(this));
        this.chkTeleportIn.setText("Teleports in");
        this.chkTeleportIn.setBounds(new Rectangle(8, 9, 154, 23));
        this.chkTeleportIn.addActionListener(new ObjsFlagsFrame_chkTeleportIn_actionAdapter(this));
        this.jButton1.setBounds(new Rectangle(52, 153, 78, 26));
        this.jButton1.setSelected(true);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ObjsFlagsFrame_jButton1_actionAdapter(this));
        this.chkFloats.addActionListener(new ObjsFlagsFrame_chkFloats_actionAdapter(this));
        this.getContentPane().add(this.chkTeleportIn);
        this.getContentPane().add(this.chkFromCeiling);
        this.getContentPane().add(this.chkFloats);
        this.getContentPane().add(this.chkDeaf);
        this.getContentPane().add(this.chkPlatformSound);
        this.getContentPane().add(this.chkNetworkOnly);
        this.getContentPane().add(this.chkBlind);
        this.getContentPane().add(this.jButton1);
        this.chkFloats.setEnabled(true);
        this.chkFloats.setText("Floats");
        this.chkFloats.setBounds(new Rectangle(8, 104, 165, 23));
        this.showRelevantBoxes();
        this.fillBoxes();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.jButton1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.chkTeleportIn.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.chkFromCeiling.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.chkPlatformSound.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.chkBlind.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.chkDeaf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.chkFloats.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.chkNetworkOnly.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjsFlagsFrame.this.closeWindow();
                }
            }
        });
        this.setSize(200, 210);
        this.setResizable(false);
        this.setTitle("Object flags");
        StaticFunctions.centerFrame(this);
        this.setVisible(true);
    }

    public void closeWindow() {
        this.model.removeChildFrame(this);
        this.dispose();
    }

    private void showRelevantBoxes() {
        try {
            if (this.entry.getType() == 0) {
                this.chkPlatformSound.setVisible(false);
                this.chkNetworkOnly.setVisible(false);
                this.chkFloats.setText("Teleports out");
            } else if (this.entry.getType() == 1) {
                this.chkTeleportIn.setVisible(false);
                this.chkPlatformSound.setVisible(false);
                this.chkBlind.setVisible(false);
                this.chkDeaf.setVisible(false);
                this.chkFloats.setVisible(false);
                this.chkNetworkOnly.setVisible(false);
            } else if (this.entry.getType() == 2) {
                this.chkPlatformSound.setVisible(false);
                this.chkBlind.setVisible(false);
                this.chkDeaf.setVisible(false);
                this.chkFloats.setVisible(false);
            } else if (this.entry.getType() == 3) {
                this.chkTeleportIn.setVisible(false);
                this.chkPlatformSound.setVisible(false);
                this.chkBlind.setVisible(false);
                this.chkDeaf.setVisible(false);
                this.chkFloats.setVisible(false);
                this.chkNetworkOnly.setVisible(false);
            } else if (this.entry.getType() == 4) {
                this.chkTeleportIn.setVisible(false);
                this.chkPlatformSound.setVisible(false);
                this.chkFromCeiling.setVisible(false);
                this.chkBlind.setVisible(false);
                this.chkDeaf.setVisible(false);
                this.chkFloats.setVisible(false);
                this.chkNetworkOnly.setVisible(false);
            } else if (this.entry.getType() == 5) {
                this.chkTeleportIn.setVisible(false);
                this.chkBlind.setVisible(false);
                this.chkDeaf.setVisible(false);
                this.chkNetworkOnly.setVisible(false);
                this.chkPlatformSound.setText("Is on platform");
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void fillBoxes() {
        try {
            short flags = this.entry.getFlags();
            if (this.entry.getType() == 0) {
                this.chkTeleportIn.setSelected((flags & 1) != 0);
                this.chkFloats.setSelected((flags & 0x10) != 0);
                this.chkFromCeiling.setSelected((flags & 2) != 0);
                this.chkBlind.setSelected((flags & 4) != 0);
                this.chkDeaf.setSelected((flags & 8) != 0);
            } else if (this.entry.getType() == 1) {
                this.chkFromCeiling.setSelected((flags & 2) != 0);
            } else if (this.entry.getType() == 2) {
                this.chkTeleportIn.setSelected((flags & 1) != 0);
                this.chkFromCeiling.setSelected((flags & 2) != 0);
                this.chkNetworkOnly.setSelected(flags * 32 != 0);
            } else if (this.entry.getType() == 3) {
                this.chkFromCeiling.setSelected((flags & 2) != 0);
            } else if (this.entry.getType() != 4 && this.entry.getType() == 5) {
                this.chkPlatformSound.setSelected((flags & 1) != 0);
                this.chkFromCeiling.setSelected((flags & 2) != 0);
                this.chkFloats.setSelected((flags & 0x10) != 0);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void jButton1_actionPerformed(ActionEvent e) {
        this.closeWindow();
    }

    public void chkTeleportIn_actionPerformed(ActionEvent e) {
        try {
            int flags = this.entry.getFlags();
            flags = this.chkTeleportIn.isSelected() ? (flags |= 1) : (flags &= 0xFFFE);
            this.entry.setFlags((short)flags);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void chkPlatformSound_actionPerformed(ActionEvent e) {
        try {
            int flags = this.entry.getFlags();
            flags = this.chkPlatformSound.isSelected() ? (flags |= 1) : (flags &= 0xFFFE);
            this.entry.setFlags((short)flags);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void chkFromCeiling_actionPerformed(ActionEvent e) {
        try {
            int flags = this.entry.getFlags();
            flags = this.chkFromCeiling.isSelected() ? (flags |= 2) : (flags &= 0xFFFD);
            this.entry.setFlags((short)flags);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void chkBlind_actionPerformed(ActionEvent e) {
        try {
            int flags = this.entry.getFlags();
            flags = this.chkBlind.isSelected() ? (flags |= 4) : (flags &= 0xFFFB);
            this.entry.setFlags((short)flags);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void chkDeaf_actionPerformed(ActionEvent e) {
        try {
            int flags = this.entry.getFlags();
            flags = this.chkDeaf.isSelected() ? (flags |= 8) : (flags &= 0xFFF7);
            this.entry.setFlags((short)flags);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void chkFloats_actionPerformed(ActionEvent e) {
        try {
            int flags = this.entry.getFlags();
            flags = this.chkFloats.isSelected() ? (flags |= 0x10) : (flags &= 0xFFEF);
            this.entry.setFlags((short)flags);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void chkNetworkOnly_actionPerformed(ActionEvent e) {
        try {
            int flags = this.entry.getFlags();
            flags = this.chkNetworkOnly.isSelected() ? (flags |= 0x20) : (flags &= 0xFFDF);
            this.entry.setFlags((short)flags);
        }
        catch (Exception ex) {
            return;
        }
    }
}

