/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import src.backend.StaticFunctions;
import src.gui.LinsTableModel;
import src.gui.Model;

public class LinsFrame
extends JFrame {
    private String[] columnNames = new String[]{"Index", "Solid", "Transparent", "Landscaped", "Length", "High Floor", "Low Ceiling", "CW poly owner", "CCW poly owner"};
    private Model model;
    private int levelIndex;
    private JTable table;
    private JScrollPane scroller;
    private LinsTableModel tableModel;
    private int clickCount;

    public LinsFrame(Model model, int levelIndex) {
        try {
            this.model = model;
            this.levelIndex = levelIndex;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.tableModel = new LinsTableModel(this.columnNames, this.model, this.levelIndex);
        this.tableModel.addTableModelListener(new LinsTableModelListener());
        this.table = new JTable(this.tableModel);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        TableColumn solidCol = this.table.getColumnModel().getColumn(1);
        TableColumn transparentCol = this.table.getColumnModel().getColumn(2);
        TableColumn landscapedCol = this.table.getColumnModel().getColumn(3);
        TableColumn cpowner = this.table.getColumnModel().getColumn(7);
        TableColumn ccpowner = this.table.getColumnModel().getColumn(8);
        JCheckBox chkSolid = new JCheckBox();
        JCheckBox chkTransparent = new JCheckBox();
        JCheckBox chkLandscape = new JCheckBox();
        solidCol.setCellEditor(new DefaultCellEditor(chkSolid));
        transparentCol.setCellEditor(new DefaultCellEditor(chkTransparent));
        landscapedCol.setCellEditor(new DefaultCellEditor(chkLandscape));
        solidCol.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JCheckBox box = new JCheckBox();
                box.setBackground(Color.white);
                try {
                    if (((Boolean)value).booleanValue()) {
                        box.setSelected(true);
                        return box;
                    }
                    box.setSelected(false);
                    return box;
                }
                catch (Exception exception) {
                    return new JCheckBox();
                }
            }
        });
        transparentCol.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JCheckBox box = new JCheckBox();
                box.setBackground(Color.white);
                try {
                    if (((Boolean)value).booleanValue()) {
                        box.setSelected(true);
                        return box;
                    }
                    box.setSelected(false);
                    return box;
                }
                catch (Exception exception) {
                    return new JCheckBox();
                }
            }
        });
        landscapedCol.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JCheckBox box = new JCheckBox();
                box.setBackground(Color.white);
                try {
                    if (((Boolean)value).booleanValue()) {
                        box.setSelected(true);
                        return box;
                    }
                    box.setSelected(false);
                    return box;
                }
                catch (Exception exception) {
                    return new JCheckBox();
                }
            }
        });
        cpowner.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTextArea text = new JTextArea();
                text.setBackground(Color.LIGHT_GRAY);
                try {
                    text.setText(Integer.toString((Integer)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return text;
            }
        });
        ccpowner.setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTextArea text = new JTextArea();
                text.setBackground(Color.LIGHT_GRAY);
                try {
                    if ((Integer)value == -1) {
                        text.setText("None");
                    } else {
                        text.setText(Integer.toString((Integer)value));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return text;
            }
        });
        this.scroller = new JScrollPane(this.table);
        this.table.getTableHeader().addMouseListener(new MouseListener(){

            public void mouseExited(MouseEvent m) {
            }

            public void mouseEntered(MouseEvent m) {
            }

            public void mouseReleased(MouseEvent m) {
            }

            public void mousePressed(MouseEvent m) {
            }

            public void mouseClicked(MouseEvent m) {
                Point mousePoint = new Point(m.getX(), m.getY());
                int header = LinsFrame.this.table.getTableHeader().columnAtPoint(mousePoint);
                LinsFrame linsFrame = LinsFrame.this;
                linsFrame.clickCount = linsFrame.clickCount + 1;
                boolean reverseOrder = false;
                if (LinsFrame.this.clickCount % 2 == 0) {
                    reverseOrder = true;
                }
                LinsFrame.this.tableModel.sort(header, reverseOrder);
            }
        });
        this.getContentPane().add(this.scroller);
        this.addWindowListener(new WindowListener(){

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                LinsFrame.this.closeTable();
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        this.clickCount = 0;
        this.setSize(600, 500);
        this.setTitle("Lines - " + this.model.getLevelSelectName());
        StaticFunctions.centerFrame(this);
        this.setVisible(true);
    }

    private void closeTable() {
        this.model.removeChildFrame(this);
    }

    class LinsTableModelListener
    implements TableModelListener {
        LinsTableModelListener() {
        }

        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 0) {
                int column = evt.getColumn();
                int row = evt.getFirstRow();
                try {
                    LinsFrame.this.table.setRowSelectionInterval(row, row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

