/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import src.backend.Preferences;
import src.backend.StaticFunctions;
import src.backend.TextureScriptParser;
import src.gui.ConvertFrame_btnCancel_actionAdapter;
import src.gui.ConvertFrame_btnOK_actionAdapter;
import src.gui.ConvertFrame_chkTransferMode_actionAdapter;
import src.gui.ConvertFrame_chkUseScript_actionAdapter;
import src.gui.ConvertFrame_cmbFromCollection_actionAdapter;
import src.gui.ConvertFrame_cmbToCollection_actionAdapter;
import src.gui.Model;

public class ConvertFrame
extends JFrame {
    private Model model;
    private int levelIndex;
    JCheckBox chkUseScript = new JCheckBox();
    JButton btnOK = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JComboBox cmbFromCollection = new JComboBox();
    JComboBox cmbToCollection = new JComboBox();
    JButton btnCancel = new JButton();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JTextField txtFromBitmap = new JTextField();
    JTextField txtToBitmap = new JTextField();
    JCheckBox jCheckBox1 = new JCheckBox();
    JCheckBox chkTransferMode = new JCheckBox();
    JLabel jLabel8 = new JLabel();
    JComboBox cmbFromTransfer = new JComboBox();
    JComboBox cmbToTransfer = new JComboBox();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();

    public ConvertFrame(Model model, int levelIndex) {
        try {
            this.model = model;
            this.levelIndex = levelIndex;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.chkUseScript.setText("Use converter script");
        this.chkUseScript.setBounds(new Rectangle(7, 11, 149, 21));
        this.chkUseScript.addActionListener(new ConvertFrame_chkUseScript_actionAdapter(this));
        this.btnOK.setBounds(new Rectangle(101, 215, 80, 31));
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ConvertFrame_btnOK_actionAdapter(this));
        this.jLabel1.setText("From:");
        this.jLabel1.setBounds(new Rectangle(7, 64, 103, 19));
        this.jLabel2.setText("Collection:");
        this.jLabel2.setBounds(new Rectangle(7, 84, 103, 19));
        this.cmbFromCollection.setBounds(new Rectangle(7, 109, 97, 18));
        this.cmbFromCollection.addActionListener(new ConvertFrame_cmbFromCollection_actionAdapter(this));
        this.cmbToCollection.setBounds(new Rectangle(7, 183, 97, 18));
        this.cmbToCollection.addActionListener(new ConvertFrame_cmbToCollection_actionAdapter(this));
        this.btnCancel.setBounds(new Rectangle(190, 215, 80, 31));
        this.btnCancel.setText("Done");
        this.btnCancel.addActionListener(new ConvertFrame_btnCancel_actionAdapter(this));
        this.jLabel3.setFont(new Font("Dialog", 0, 15));
        this.jLabel3.setText("Swap a transfer mode");
        this.jLabel3.setBounds(new Rectangle(227, 37, 210, 29));
        this.jLabel4.setText("Bitmap:");
        this.jLabel4.setBounds(new Rectangle(117, 159, 103, 19));
        this.jLabel5.setText("Collection:");
        this.jLabel5.setBounds(new Rectangle(7, 159, 103, 19));
        this.jLabel6.setText("To:");
        this.jLabel6.setBounds(new Rectangle(7, 133, 94, 18));
        this.jLabel7.setText("Bitmap:");
        this.jLabel7.setBounds(new Rectangle(117, 84, 103, 19));
        this.txtFromBitmap.setBounds(new Rectangle(117, 109, 97, 18));
        this.txtToBitmap.setText("");
        this.txtToBitmap.setBounds(new Rectangle(117, 183, 97, 18));
        this.jCheckBox1.setText("Use converter script");
        this.jCheckBox1.setBounds(new Rectangle(7, 11, 149, 21));
        this.chkTransferMode.setText("Convert transfer modes");
        this.chkTransferMode.setBounds(new Rectangle(195, 11, 197, 21));
        this.chkTransferMode.addActionListener(new ConvertFrame_chkTransferMode_actionAdapter(this));
        this.jLabel8.setFont(new Font("Dialog", 0, 15));
        this.jLabel8.setText("Swap texture");
        this.jLabel8.setBounds(new Rectangle(62, 37, 135, 29));
        this.cmbFromTransfer.setBounds(new Rectangle(254, 109, 97, 18));
        this.cmbToTransfer.setBounds(new Rectangle(254, 183, 97, 18));
        this.jLabel9.setToolTipText("");
        this.jLabel9.setText("Transfer mode:");
        this.jLabel9.setBounds(new Rectangle(254, 84, 103, 19));
        this.jLabel10.setText("Transfer Mode:");
        this.jLabel10.setBounds(new Rectangle(254, 159, 103, 19));
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.jLabel6);
        this.getContentPane().add(this.jLabel5);
        this.getContentPane().add(this.cmbToCollection);
        this.getContentPane().add(this.jLabel2);
        this.getContentPane().add(this.jLabel7);
        this.getContentPane().add(this.jLabel4);
        this.getContentPane().add(this.txtFromBitmap);
        this.getContentPane().add(this.chkUseScript);
        this.getContentPane().add(this.jLabel8);
        this.getContentPane().add(this.jLabel3);
        this.getContentPane().add(this.cmbFromCollection);
        this.getContentPane().add(this.cmbToTransfer);
        this.getContentPane().add(this.cmbFromTransfer);
        this.getContentPane().add(this.txtToBitmap);
        this.getContentPane().add(this.btnCancel);
        this.getContentPane().add(this.btnOK);
        this.getContentPane().add(this.jLabel9);
        this.getContentPane().add(this.jLabel10);
        this.getContentPane().add(this.chkTransferMode);
        this.cmbFromCollection.addItem("Water");
        this.cmbFromCollection.addItem("Lava");
        this.cmbFromCollection.addItem("Sewage");
        this.cmbFromCollection.addItem("Jjaro");
        this.cmbFromCollection.addItem("Pfhor");
        this.cmbToCollection.addItem("Water");
        this.cmbToCollection.addItem("Lava");
        this.cmbToCollection.addItem("Sewage");
        this.cmbToCollection.addItem("Jjaro");
        this.cmbToCollection.addItem("Pfhor");
        int i = 0;
        while (i < StaticFunctions.TRANSFER_MODES.length) {
            this.cmbFromTransfer.addItem(StaticFunctions.TRANSFER_MODES[i]);
            this.cmbToTransfer.addItem(StaticFunctions.TRANSFER_MODES[i]);
            ++i;
        }
        this.cmbFromTransfer.setEnabled(false);
        this.cmbToTransfer.setEnabled(false);
        this.setSize(400, 300);
        this.setTitle("Convert Textures...");
        this.setResizable(false);
        StaticFunctions.centerFrame(this);
        this.setVisible(true);
    }

    public void btnOK_actionPerformed(ActionEvent e) {
        int bmp1 = 0;
        int bmp2 = 0;
        if (!this.chkUseScript.isSelected()) {
            try {
                bmp1 = Integer.parseInt(this.txtFromBitmap.getText());
                bmp2 = Integer.parseInt(this.txtToBitmap.getText());
                if (bmp1 < -5) {
                    bmp1 = 0;
                }
                if (bmp1 > 65535) {
                    bmp1 = 65535;
                }
                if (bmp2 < -5) {
                    bmp2 = 0;
                }
                if (bmp2 > 65535) {
                    bmp2 = 65535;
                }
            }
            catch (Exception ex) {
                return;
            }
        }
        if (!this.chkUseScript.isSelected() && this.chkTransferMode.isSelected()) {
            this.model.convertTextures(this.levelIndex, this.cmbFromCollection.getSelectedIndex() + 17, bmp1, this.cmbFromTransfer.getSelectedIndex(), this.cmbToCollection.getSelectedIndex() + 17, bmp2, this.cmbToTransfer.getSelectedIndex());
        } else if (!this.chkUseScript.isSelected()) {
            this.model.convertTextures(this.levelIndex, this.cmbFromCollection.getSelectedIndex() + 17, bmp1, this.cmbToCollection.getSelectedIndex() + 17, bmp2);
        } else if (this.chkUseScript.isSelected()) {
            String openFile = "";
            String saveFile = "";
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(Preferences.SCRIPTS_PATH));
            int retVal = fc.showOpenDialog(this);
            if (retVal == 0) {
                openFile = fc.getSelectedFile().getPath();
            } else if (retVal == 1) {
                return;
            }
            saveFile = String.valueOf(openFile) + ".undo";
            TextureScriptParser t = new TextureScriptParser(this.levelIndex, this.model, openFile, saveFile);
            this.model.removeChildFrame(this);
            this.dispose();
        }
    }

    public void btnCancel_actionPerformed(ActionEvent e) {
        this.model.removeChildFrame(this);
        this.dispose();
    }

    public void cmbFromCollection_actionPerformed(ActionEvent e) {
        if (this.cmbFromCollection.getSelectedItem().equals("Jjaro")) {
            int i = 0;
            while (i < 35) {
                ++i;
            }
        } else {
            int i = 0;
            while (i < 30) {
                ++i;
            }
        }
    }

    public void cmbToCollection_actionPerformed(ActionEvent e) {
        if (this.cmbToCollection.getSelectedItem().equals("Jjaro")) {
            int i = 0;
            while (i < 35) {
                ++i;
            }
        } else {
            int i = 0;
            while (i < 30) {
                ++i;
            }
        }
    }

    public void chkUseScript_actionPerformed(ActionEvent e) {
        if (this.chkUseScript.isSelected()) {
            this.cmbFromCollection.setEnabled(false);
            this.cmbToCollection.setEnabled(false);
            this.txtFromBitmap.setEnabled(false);
            this.txtToBitmap.setEnabled(false);
            this.chkTransferMode.setEnabled(false);
            this.cmbFromTransfer.setEnabled(false);
            this.cmbToTransfer.setEnabled(false);
        } else if (!this.chkUseScript.isSelected() && this.chkTransferMode.isSelected()) {
            this.cmbFromCollection.setEnabled(true);
            this.cmbToCollection.setEnabled(true);
            this.txtFromBitmap.setEnabled(true);
            this.txtToBitmap.setEnabled(true);
            this.chkTransferMode.setEnabled(true);
            this.cmbFromTransfer.setEnabled(true);
            this.cmbToTransfer.setEnabled(true);
        } else if (!this.chkUseScript.isSelected() && !this.chkTransferMode.isSelected()) {
            this.cmbFromCollection.setEnabled(true);
            this.cmbToCollection.setEnabled(true);
            this.txtFromBitmap.setEnabled(true);
            this.txtToBitmap.setEnabled(true);
            this.chkTransferMode.setEnabled(true);
        }
    }

    public void chkTransferMode_actionPerformed(ActionEvent e) {
        if (this.chkTransferMode.isSelected()) {
            this.cmbFromTransfer.setEnabled(true);
            this.cmbToTransfer.setEnabled(true);
        } else {
            this.cmbFromTransfer.setEnabled(false);
            this.cmbToTransfer.setEnabled(false);
        }
    }
}

