/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.ArrayList;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.Level;
import src.backend.MapWriter;
import src.backend.ShapeDescriptor;
import src.backend.SideTexture;
import src.backend.SidsEntry;
import src.backend.StaticFunctions;

public class SidsChunk
extends Chunk {
    private ArrayList entries = new ArrayList(0);
    private int numEntries;

    public SidsChunk(Level level, ChunkHeader header) {
        super(level, header);
    }

    public SidsChunk() {
    }

    public SidsEntry getEntry(int entry) {
        if (entry < this.entries.size()) {
            return (SidsEntry)this.entries.get(entry);
        }
        System.out.println("ObjsChunk does not contain that many entries. Returning highest entry.");
        return (SidsEntry)this.entries.get(this.entries.size() - 1);
    }

    public void read() {
        super.read();
        MapWriter mw = this.level.getMapData().getMapWriter();
        this.numEntries = this.header.getLength() / 64;
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.numEntries) {
            SidsEntry sidsEntry = new SidsEntry(this);
            sidsEntry.read();
            this.entries.add(sidsEntry);
            ++i;
        }
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.entries.size()) {
            ((SidsEntry)this.entries.get(i)).write();
            ++i;
        }
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public int getEntryLength() {
        return 64;
    }

    public SidsEntry addEntry() {
        SidsEntry o = new SidsEntry(this);
        int len = this.getEntryLength();
        this.header.autoAdjust(len);
        ++this.numEntries;
        return o;
    }

    public void addEntry(SidsEntry oe) {
        int len = this.getEntryLength();
        this.entries.add(oe);
        this.header.autoAdjust(len);
        ++this.numEntries;
    }

    public SidsEntry removeEntry(SidsEntry o) {
        int i = 0;
        while (i < this.entries.size()) {
            if (o.equals(this.getEntry(i))) {
                this.entries.remove(i);
                int len = -1 * this.getEntryLength();
                this.header.autoAdjust(len);
                --this.numEntries;
                return o;
            }
            ++i;
        }
        System.out.println("That SidsEntry does not exist in the SidsChunk and can't be removed.");
        return o;
    }

    public void convertTextures() {
        int i = 0;
        while (i < this.entries.size()) {
            SidsEntry se = (SidsEntry)this.entries.get(i);
            SideTexture[] st = se.getSideTextures();
            int j = 0;
            while (j < st.length) {
                ShapeDescriptor sd = st[j].getTexture();
                int k = 1;
                while (k < StaticFunctions.TEXTURE_CUTOFFS.length) {
                    if (sd.getColl() == 17 && sd.getBmp() >= StaticFunctions.TEXTURE_CUTOFFS[k - 1] && sd.getBmp() < StaticFunctions.TEXTURE_CUTOFFS[k]) {
                        sd.setColl(17 + k);
                        short diff = (short)(sd.getBmp() - StaticFunctions.TEXTURE_CUTOFFS[k - 1]);
                        sd.setBmp(diff);
                        sd.setColl(k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void convertTextures(short coll1, short bmp1, short coll2, short bmp2) {
        int i = 0;
        while (i < this.entries.size()) {
            SidsEntry se = (SidsEntry)this.entries.get(i);
            SideTexture[] st = se.getSideTextures();
            int j = 0;
            while (j < st.length) {
                ShapeDescriptor sd = st[j].getTexture();
                if (sd.getColl() == coll1 && sd.getBmp() == bmp1) {
                    sd.setColl(coll2);
                    sd.setBmp(bmp2);
                    if (coll2 >= 27 && coll2 <= 30) {
                        if (j == 0) {
                            se.setPrimaryTransfer((short)9);
                        } else if (j == 1) {
                            se.setSecondaryTransfer((short)9);
                        } else {
                            se.setTransparentTransfer((short)9);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void convertTextures(short coll1, short bmp1, short x1, short coll2, short bmp2, short x2) {
        int i = 0;
        while (i < this.entries.size()) {
            SidsEntry se = (SidsEntry)this.entries.get(i);
            SideTexture[] st = se.getSideTextures();
            int j = 0;
            while (j < st.length) {
                ShapeDescriptor sd = st[j].getTexture();
                if (sd.getColl() == coll1 && sd.getBmp() == bmp1) {
                    if (j == 0 && se.getPrimaryTransfer() == x1) {
                        sd.setColl(coll2);
                        sd.setBmp(bmp2);
                        se.setPrimaryTransfer(x2);
                    }
                    if (j == 1 && se.getSecondaryTransfer() == x1) {
                        se.setSecondaryTransfer(x2);
                        sd.setColl(coll2);
                        sd.setBmp(bmp2);
                    }
                    if (j == 2 && se.getTransparentTransfer() == x1) {
                        se.setTransparentTransfer(x2);
                        sd.setColl(coll2);
                        sd.setBmp(bmp2);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void convertTextures(short coll1, short bmp1, short x1, short cp1, short coll2, short bmp2, short x2, short cp2) {
        int i = 0;
        while (i < this.entries.size()) {
            boolean ok;
            SidsEntry se = (SidsEntry)this.entries.get(i);
            boolean control = (se.getFlags() & 2) != 0;
            boolean match = se.getPanelType() == cp1;
            boolean bl = ok = control && match;
            if (ok) {
                SideTexture[] st = se.getSideTextures();
                int j = 0;
                while (j < st.length) {
                    ShapeDescriptor sd = st[j].getTexture();
                    if (sd.getColl() == coll1 && sd.getBmp() == bmp1) {
                        boolean shouldSet = false;
                        if (j == 0 && se.getPrimaryTransfer() == x1) {
                            sd.setColl(coll2);
                            sd.setBmp(bmp2);
                            se.setPrimaryTransfer(x2);
                            shouldSet = true;
                        }
                        if (j == 1 && se.getSecondaryTransfer() == x1) {
                            se.setSecondaryTransfer(x2);
                            sd.setColl(coll2);
                            sd.setBmp(bmp2);
                            shouldSet = true;
                        }
                        if (j == 2 && se.getTransparentTransfer() == x1) {
                            se.setTransparentTransfer(x2);
                            sd.setColl(coll2);
                            sd.setBmp(bmp2);
                            shouldSet = true;
                        }
                        if (shouldSet) {
                            se.setPanelType(cp2);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

