/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.io.RandomAccessFile;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.Level;
import src.backend.MapWriter;
import src.backend.NotShPaException;
import src.backend.ShPaEntry;
import src.backend.TooLongException;

public class ShPaChunk
extends Chunk {
    private static final int MAXIMUM_LENGTH = 262144;
    private static final int SHPA_MAGIC_END = 1701733475;
    private ShPaEntry patch;

    public ShPaChunk(Level level, ChunkHeader header) {
        super(level, header);
    }

    public ShPaChunk() {
    }

    public ShPaChunk(byte[] data) {
        ShPaEntry e;
        this.patch = e = new ShPaEntry(this, data);
    }

    public ShPaChunk(String path) throws NotShPaException, TooLongException {
        try {
            ShPaEntry e;
            RandomAccessFile r = new RandomAccessFile(path, "r");
            if (r.length() > 262144L) {
                System.out.println("File " + path + " exceeds maximum patch length.");
                throw new TooLongException();
            }
            r.seek(r.length() - 4L);
            int magic = r.readInt();
            if (magic != 1701733475) {
                System.out.println("File " + path + " is not a shapes patch.");
                throw new NotShPaException();
            }
            r.seek(0L);
            byte[] b = new byte[(int)r.length()];
            r.read(b);
            this.patch = e = new ShPaEntry(this, b);
        }
        catch (NotShPaException notShape) {
            throw new NotShPaException();
        }
        catch (TooLongException tooLong) {
            throw new TooLongException();
        }
        catch (Exception e) {
            System.out.println("Exception in ShPa chunk:");
            e.printStackTrace();
        }
    }

    public void read() {
        ShPaEntry s;
        super.read();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        byte[] b = new byte[this.header.getLength()];
        mw.read(b);
        this.patch = s = new ShPaEntry(this, b);
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        mw.write(this.patch.getData());
    }

    public int getEntryLength() {
        return this.patch.length();
    }

    public int getNumEntries() {
        return 1;
    }

    public ShPaEntry getPatch() {
        return this.patch;
    }

    public void setPatch(ShPaEntry p) {
        int old = this.patch.length();
        int neo = p.length();
        int diff = neo - old;
        this.patch = p;
        this.header.autoAdjust(diff);
    }

    public void blankPatch() {
        byte[] data = new byte[]{};
        this.setPatch(new ShPaEntry(this, data));
    }
}

