/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Entry;
import src.backend.MapWriter;
import src.backend.ObjsChunk;
import src.backend.PlacEntry;
import src.backend.WrkArrayReader;

public class ObjsEntry
extends Entry {
    public static final int ENTRY_LENGTH = 16;
    private short type;
    private short subtype;
    private short facing;
    private short polygon;
    private short x;
    private short y;
    private short z;
    private short flags;

    public ObjsEntry(ObjsChunk chunk) {
        super(chunk);
    }

    public ObjsEntry read() {
        MapWriter mapWriter = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[16];
        mapWriter.read(data);
        WrkArrayReader wrk = new WrkArrayReader(data);
        this.type = wrk.readShort();
        this.subtype = wrk.readShort();
        this.facing = wrk.readShort();
        this.polygon = wrk.readShort();
        this.x = wrk.readShort();
        this.y = wrk.readShort();
        this.z = wrk.readShort();
        this.flags = wrk.readShort();
        return this;
    }

    public void write() {
        MapWriter mapWriter = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[16];
        WrkArrayReader wrk = new WrkArrayReader(data);
        wrk.writeShort(this.type);
        wrk.writeShort(this.subtype);
        wrk.writeShort(this.facing);
        wrk.writeShort(this.polygon);
        wrk.writeShort(this.x);
        wrk.writeShort(this.y);
        wrk.writeShort(this.z);
        wrk.writeShort(this.flags);
        mapWriter.write(data);
    }

    public short getType() {
        return this.type;
    }

    public short getSubtype() {
        return this.subtype;
    }

    public short getFacing() {
        return (short)((double)this.facing / 512.0 * 360.0);
    }

    public short getPolygon() {
        return this.polygon;
    }

    public double getX() {
        return (double)this.x / 1024.0;
    }

    public double getY() {
        return (double)this.y / 1024.0;
    }

    public double getZ() {
        return (double)this.z / 1024.0;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setType(short t) {
        short old = this.getType();
        short oldSub = this.getSubtype();
        this.type = t;
        if (old != this.type) {
            if (old == 2 || old == 0) {
                this.changePlacData(old, oldSub, -1);
            }
            if (this.type == 2 || this.type == 0) {
                this.changePlacData(this.type, this.subtype, 1);
            }
        }
    }

    public void setSubtype(short s) {
        short old = this.getType();
        short oldSub = this.getSubtype();
        this.subtype = s;
        if (oldSub != this.subtype) {
            this.changePlacData(old, oldSub, -1);
            this.changePlacData(this.type, this.subtype, 1);
        }
    }

    public void setFacing(short f) {
        short face;
        this.facing = face = (short)((double)f / 360.0 * 512.0);
    }

    public void setPolygon(short p) {
        this.polygon = p;
    }

    public void setX(double x) {
        this.x = (short)(x * 1024.0);
    }

    public void setY(double y) {
        this.y = (short)(y * 1024.0);
    }

    public void setZ(double z) {
        this.z = (short)(z * 1024.0);
    }

    public void setFlags(short f) {
        this.flags = f;
    }

    private void changePlacData(short type, short subtype, int delta) {
        if (type == 0 || type == 2) {
            PlacEntry plac;
            int begin = 0;
            int off = 0;
            if (type == 0) {
                begin = 36;
                off = 1;
            }
            if ((plac = this.chunk.getLevel().getPlacChunk().getEntry(begin + subtype + off)).getInitial() > 0 || delta > 0) {
                plac.setInitial((short)(plac.getInitial() + delta));
            }
        }
    }

    public void changePlacData(int delta) {
        if (this.type == 0 || this.type == 2) {
            PlacEntry plac;
            int begin = 0;
            int off = 0;
            if (this.type == 0) {
                begin = 36;
                off = 1;
            }
            if ((plac = this.chunk.getLevel().getPlacChunk().getEntry(begin + this.subtype + off)).getInitial() > 0 || delta > 0) {
                plac.setInitial((short)(plac.getInitial() + delta));
            }
        }
    }
}

