/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.ArrayList;
import src.backend.Level;
import src.backend.MapWriter;

public class MapData {
    private static boolean READ_PATCH = false;
    private static String PATCH_PATH = "Shapes Patch";
    private ArrayList levels;
    private MapWriter mw;
    private boolean isValidMapFile = true;
    private boolean isMergedMapFile = true;
    private short version;
    private short dataVersion;
    private char[] mapName = new char[64];
    private long checksum;
    private int mapLength;
    private short numLevels;
    private short appSpecificDirSize;
    private short entryHeaderSize;
    private short baseDirectoryEntrySize;
    private int parentChecksum;
    private long fileLength = 0L;
    private boolean hasChanged = false;
    private boolean isOptimized = false;

    public MapData(String filePath) {
        System.out.println("Reading map ...");
        long startTime = System.currentTimeMillis();
        this.mw = new MapWriter(filePath);
        if (!this.mw.getFileLoaded()) {
            return;
        }
        if (!this.mw.isValidMapFile()) {
            this.isValidMapFile = false;
            return;
        }
        this.isValidMapFile = true;
        if (this.mw.isMacBinary()) {
            this.mw.seek(83L);
            this.fileLength = this.mw.readLong();
        } else {
            this.fileLength = this.mw.length();
        }
        this.readHeader();
        this.levels = new ArrayList(0);
        int a = 0;
        while (a < this.numLevels) {
            System.out.println("Level " + a);
            Level level = new Level(this);
            this.mw.seek(this.mapLength + a * 84);
            MapData.print(this.mapLength);
            MapData.print("Seeking to " + (this.mapLength + a * 84));
            level.setOffset(this.mw.readInt());
            level.setLength(this.mw.readInt());
            long sum = level.getLength() + 128 + 10;
            if (sum == this.fileLength) {
                this.isMergedMapFile = false;
            }
            level = this.isMergedMapFile ? this.processMergedLevel(level) : this.processUnmergedLevel(level);
            MapData.print("\tName: " + level.getlevelSelectName() + "\n------------------");
            level.resetChange();
            this.levels.add(level);
            System.out.println(String.valueOf(this.levels.size()) + " levels in arraylist");
            ++a;
        }
        this.resetChange();
        System.out.println("Reading took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
    }

    public void change() {
        this.hasChanged = true;
    }

    public void resetChange() {
        this.hasChanged = false;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    private Level processMergedLevel(Level level) {
        this.mw.skipBytes(8);
        level.setFlags(this.mw.readShort());
        String tmpName = "";
        byte present = this.mw.readByte();
        while (present != 0) {
            char newChar = (char)present;
            tmpName = String.valueOf(tmpName) + newChar;
            present = this.mw.readByte();
        }
        level.setLevelSelectName(tmpName);
        level.processChunks();
        return level;
    }

    private Level processUnmergedLevel(Level level) {
        level.processChunks();
        level.setLevelSelectName(level.getMinfChunk().getName());
        level.setFlags((short)level.getMinfChunk().getEntry());
        return level;
    }

    public boolean isMergedMapFile() {
        return this.isMergedMapFile;
    }

    public void setMapWriter(MapWriter mw) {
        this.mw = mw;
        this.change();
    }

    public void setNumLevels(short numLevels) {
        this.numLevels = numLevels;
        this.change();
    }

    public void setMapLength(int mapLength) {
        int diff = mapLength - this.mapLength;
        this.mapLength = mapLength;
        MapData.print("Map Length set to " + mapLength);
        this.change();
    }

    public void setLevels(ArrayList levels) {
        this.levels = levels;
        this.change();
    }

    public void setLevel(int num, Level level) {
        this.levels.set(num, level);
        this.change();
    }

    public MapWriter getMapWriter() {
        return this.mw;
    }

    public short getNumLevels() {
        return this.numLevels;
    }

    public int getMapLength() {
        return this.mapLength;
    }

    public ArrayList getLevels() {
        return this.levels;
    }

    public Level getLevel(int num) {
        return (Level)this.levels.get(num);
    }

    public boolean getIsValidMap() {
        return this.isValidMapFile;
    }

    public boolean isOptimized() {
        return this.isOptimized;
    }

    public void setOptimized(boolean b) {
        this.isOptimized = b;
    }

    public static void print(String msg) {
        System.out.println(msg);
    }

    public static void print(long msg) {
        System.out.println(msg);
    }

    public void write() {
        System.out.println("Saving map...");
        long startTime = System.currentTimeMillis();
        this.mw.setFileSize(this);
        this.mw.zeroMap();
        if (this.mw.isMacBinary()) {
            this.mw.writeMacBinary();
        }
        this.writeHeader();
        int i = 0;
        while (i < this.numLevels) {
            System.out.print("\n\tWriting level " + i);
            this.getLevel(i).write();
            this.getLevel(i).resetChange();
            ++i;
        }
        this.writeTrailers();
        this.writeChecksum();
        this.resetChange();
        System.out.println("Writing took " + (System.currentTimeMillis() - startTime) + " milliseconds.");
    }

    public void writeFlags(int level) {
        short flags = ((Level)this.levels.get(level)).getFlags();
        this.mw.seek(this.mapLength + 84 * level + 16);
        this.mw.writeShort(flags);
    }

    public void writeTrailers() {
        int i = 0;
        while (i < this.numLevels) {
            this.writeOffset(i);
            this.writeLength(i);
            if (this.isMergedMapFile) {
                this.writeIndex(i);
                this.writeFlags(i);
                this.writeLevelSelectName(i);
            } else {
                this.mw.writeShort((short)0);
            }
            ++i;
        }
    }

    public void writeIndex(int level) {
        this.mw.seek(this.mapLength + 84 * level + 8);
        this.mw.writeShort((short)level);
    }

    public void writeLevelSelectName(int level) {
        String levelSelectName = ((Level)this.levels.get(level)).getlevelSelectName();
        if (levelSelectName.length() > 64) {
            levelSelectName = levelSelectName.substring(0, 64);
        }
        this.mw.seek(this.mapLength + 84 * level + 18);
        int i = 0;
        while (i < 64) {
            if (i < levelSelectName.length()) {
                this.mw.writeByte(levelSelectName.charAt(i));
            } else {
                this.mw.writeByte(0);
            }
            ++i;
        }
    }

    public void writeOffset(int level) {
        int offset = ((Level)this.levels.get(level)).getOffset();
        this.mw.seek(this.mapLength + 84 * level);
        this.mw.writeInt(offset);
    }

    public void writeLength(int level) {
        int length = ((Level)this.levels.get(level)).getLength();
        this.mw.seek(this.mapLength + 84 * level + 4);
        this.mw.writeInt(length);
    }

    public void autoAdjust(int len, int off) {
        System.out.println("Autoadjusting map.");
        int i = 0;
        while (i < this.levels.size()) {
            System.out.println("Level " + i);
            Level level = (Level)this.levels.get(i);
            System.out.println("Level " + i + " autoAdjust:");
            level.autoAdjust(len, off);
            ++i;
        }
        this.adjust(len);
    }

    public void adjust(int len) {
        this.setMapLength(this.getMapLength() + len);
    }

    public void readHeader() {
        this.mw.seek(0L);
        this.version = this.mw.readShort();
        MapData.print(this.version);
        this.dataVersion = this.mw.readShort();
        MapData.print(String.valueOf(this.dataVersion) + "\n");
        int z = 0;
        while (z < 64) {
            this.mapName[z] = (char)this.mw.readByte();
            if (this.mapName[z] != '\u0000') {
                System.out.print(this.mapName[z]);
            }
            ++z;
        }
        this.checksum = this.mw.readInt();
        MapData.print("\n" + this.checksum);
        this.mapLength = this.mw.readInt();
        MapData.print(this.mapLength);
        this.numLevels = this.mw.readShort();
        MapData.print(String.valueOf(this.numLevels) + " level(s) found in map.");
        this.appSpecificDirSize = this.mw.readShort();
        this.entryHeaderSize = this.mw.readShort();
        this.parentChecksum = this.mw.readInt();
    }

    public void writeHeader() {
        this.mw.seek(0L);
        this.mw.writeShort(this.version);
        this.mw.writeShort(this.dataVersion);
        int z = 0;
        while (z < 64) {
            this.mw.writeByte((byte)this.mapName[z]);
            ++z;
        }
        System.out.println("Original Checksum: " + (int)this.checksum);
        this.mw.writeInt(0);
        this.mw.writeInt(this.mapLength);
        MapData.print(this.mapLength);
        this.mw.writeShort(this.numLevels);
        this.mw.writeShort(this.appSpecificDirSize);
        this.mw.writeShort(this.entryHeaderSize);
        this.mw.writeInt(this.parentChecksum);
        int i = 0;
        while (i < 20) {
            this.mw.writeShort((short)0);
            ++i;
        }
    }

    public void writeNew(String path) {
        this.mw.newRF(path, this);
        this.write();
    }

    public void writeChecksum() {
        int trailerLength = this.numLevels * 84;
        if (!this.isMergedMapFile) {
            trailerLength = 10;
        }
        this.checksum = this.mw.generateChecksum(this.mapLength, trailerLength);
        System.out.println("\nNew Checksum     : " + (int)this.checksum);
        this.mw.seek(68L);
        this.mw.writeInt((int)this.checksum);
    }
}

