/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Entry;
import src.backend.LinsChunk;
import src.backend.MapWriter;
import src.backend.WrkArrayReader;

public class LinsEntry
extends Entry {
    public static final int ENTRY_LENGTH = 32;
    private short endpoint1;
    private short endpoint2;
    private short flags;
    private short length;
    private short highest_adjacent_floor;
    private short lowest_adjacent_ceiling;
    private short clockwise_poly_side_index;
    private short counterclockwise_poly_side_index;
    private short clockwise_poly_owner;
    private short counterclockwise_poly_owner;
    private short[] unused_bastards = new short[6];

    public LinsEntry(LinsChunk chunk) {
        super(chunk);
    }

    public LinsEntry read() {
        MapWriter mapWriter = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[32];
        mapWriter.read(data);
        WrkArrayReader wrk = new WrkArrayReader(data);
        this.endpoint1 = wrk.readShort();
        this.endpoint2 = wrk.readShort();
        this.flags = wrk.readShort();
        this.length = wrk.readShort();
        this.highest_adjacent_floor = wrk.readShort();
        this.lowest_adjacent_ceiling = wrk.readShort();
        this.clockwise_poly_side_index = wrk.readShort();
        this.counterclockwise_poly_side_index = wrk.readShort();
        this.clockwise_poly_owner = wrk.readShort();
        this.counterclockwise_poly_owner = wrk.readShort();
        int i = 0;
        while (i < this.unused_bastards.length) {
            this.unused_bastards[i] = wrk.readShort();
            ++i;
        }
        return this;
    }

    public void write() {
        MapWriter mapWriter = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[32];
        WrkArrayReader wrk = new WrkArrayReader(data);
        wrk.writeShort(this.endpoint1);
        wrk.writeShort(this.endpoint2);
        wrk.writeShort(this.flags);
        wrk.writeShort(this.length);
        wrk.writeShort(this.highest_adjacent_floor);
        wrk.writeShort(this.lowest_adjacent_ceiling);
        wrk.writeShort(this.clockwise_poly_side_index);
        wrk.writeShort(this.counterclockwise_poly_side_index);
        wrk.writeShort(this.clockwise_poly_owner);
        wrk.writeShort(this.counterclockwise_poly_owner);
        int i = 0;
        while (i < this.unused_bastards.length) {
            wrk.writeShort(this.unused_bastards[i]);
            ++i;
        }
        mapWriter.write(data);
    }

    public short[] getEndpoints() {
        short[] epnt = new short[]{this.endpoint1, this.endpoint2};
        return epnt;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getLength() {
        return this.length;
    }

    public short getHighestAdjacentFloor() {
        return this.highest_adjacent_floor;
    }

    public short getLowestAdjacentCeiling() {
        return this.lowest_adjacent_ceiling;
    }

    public short getClockwisePolySideIndex() {
        return this.clockwise_poly_side_index;
    }

    public short getCounterClockwisePolySideIndex() {
        return this.counterclockwise_poly_side_index;
    }

    public short getClockwisePolyOwner() {
        return this.clockwise_poly_owner;
    }

    public short getCounterClockwisePolyOwner() {
        return this.counterclockwise_poly_owner;
    }

    public void setEndpoints(short e1, short e2) {
        this.endpoint1 = e1;
        this.endpoint2 = e2;
    }

    public void setEndpoints(short[] e) {
        this.endpoint1 = e[0];
        this.endpoint2 = e[1];
    }

    public void setFlags(int flags) {
        System.out.println("Flags orig: " + this.flags);
        this.flags = (short)flags;
        System.out.println("Flags new : " + this.flags);
    }

    public void setFlags(short flags) {
        this.flags = flags;
        System.out.println("Flag set to " + flags);
    }

    public void setLength(short length) {
        this.length = length;
    }

    public void setHighestAdjacentFloor(short h) {
        this.highest_adjacent_floor = h;
    }

    public void setLowestAdjacentCeiling(short l) {
        this.lowest_adjacent_ceiling = l;
    }

    public void setClockwisePolySideIndex(short c) {
        this.clockwise_poly_side_index = c;
    }

    public void setCounterClockwisePolySideIndex(short c) {
        this.counterclockwise_poly_side_index = c;
    }

    public void setClockwisePolyOwner(short c) {
        this.clockwise_poly_owner = c;
    }

    public void setCounterClockwisePolyOwner(short c) {
        this.counterclockwise_poly_owner = c;
    }
}

