/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.ArrayList;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.Level;
import src.backend.LinsEntry;
import src.backend.MapWriter;

public class LinsChunk
extends Chunk {
    private ArrayList entries = new ArrayList(0);
    private int numEntries;

    public LinsChunk(Level level, ChunkHeader header) {
        super(level, header);
    }

    public LinsChunk() {
    }

    public LinsEntry getEntry(int entry) {
        if (entry < this.entries.size()) {
            return (LinsEntry)this.entries.get(entry);
        }
        System.out.println("ObjsChunk does not contain that many entries. Returning highest entry.");
        return (LinsEntry)this.entries.get(this.entries.size() - 1);
    }

    public void read() {
        super.read();
        MapWriter mw = this.level.getMapData().getMapWriter();
        this.numEntries = this.header.getLength() / 32;
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.numEntries) {
            LinsEntry linsEntry = new LinsEntry(this);
            linsEntry.read();
            this.entries.add(linsEntry);
            ++i;
        }
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        int i = 0;
        while (i < this.entries.size()) {
            ((LinsEntry)this.entries.get(i)).write();
            ++i;
        }
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public int getEntryLength() {
        return 32;
    }

    public LinsEntry addEntry() {
        LinsEntry o = new LinsEntry(this);
        int len = this.getEntryLength();
        this.header.autoAdjust(len);
        ++this.numEntries;
        return o;
    }

    public void addEntry(LinsEntry oe) {
        int len = this.getEntryLength();
        this.entries.add(oe);
        this.header.autoAdjust(len);
        ++this.numEntries;
    }

    public LinsEntry removeEntry(LinsEntry o) {
        int i = 0;
        while (i < this.entries.size()) {
            if (o.equals(this.getEntry(i))) {
                this.entries.remove(i);
                int len = -1 * this.getEntryLength();
                this.header.autoAdjust(len);
                --this.numEntries;
                return o;
            }
            ++i;
        }
        System.out.println("That LinsEntry does not exist in the LinsChunk and can't be removed.");
        return o;
    }
}

