/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.ArrayList;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.JuceEntry;
import src.backend.Level;
import src.backend.MapWriter;

public class JuceChunk
extends Chunk {
    private ArrayList entries = new ArrayList(0);

    public JuceChunk() {
    }

    public JuceChunk(Level level, ChunkHeader header) {
        super(level, header);
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        int numEntries = this.header.getLength() / 512;
        int i = 0;
        while (i < numEntries) {
            mw.seek(this.header.getOffset() + 16 + i * 512);
            byte[] data = new byte[512];
            mw.read(data);
            JuceEntry juceEntry = new JuceEntry(this, data);
            this.entries.add(juceEntry);
            ++i;
        }
    }

    public JuceChunk(String comment) {
        JuceEntry entry = new JuceEntry(this);
        this.entries.add(entry);
        this.setComment(comment);
    }

    public String getComment() {
        return ((JuceEntry)this.entries.get(0)).getComment();
    }

    public void setComment(String comment) {
        if (this.entries.get(0) == null) {
            JuceEntry entry = new JuceEntry(this);
            this.entries.add(entry);
        }
        ((JuceEntry)this.entries.get(0)).setComment(comment);
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        System.out.println("Writing JUCE @ " + (this.header.getOffset() + 16));
        int i = 0;
        while (i < this.entries.size()) {
            System.out.println("Writing comment:\n" + ((JuceEntry)this.entries.get(i)).getComment());
            ((JuceEntry)this.entries.get(i)).write();
            ++i;
        }
    }

    public int getEntryLength() {
        JuceEntry cfr_ignored_0 = (JuceEntry)this.entries.get(0);
        return 512;
    }

    public int getNumEntries() {
        return this.entries.size();
    }
}

