/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.gui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jp.hpl.data.DefaultMarathonDataModel;
import jp.hpl.gui.IMapViewerFrame;
import jp.hpl.gui.MapCanvas;
import jp.hpl.gui.SelectLevelDialog;
import jp.hpl.gui.preferences.Preferences;
import jp.hpl.gui.render.VisualModeDialog;
import jp.hpl.gui.thread.ProgressBarDialog;
import jp.hpl.gui.thread.ProgressLoadThread;

public class MainViewFrame
extends JFrame
implements IMapViewerFrame {
    private int levelIndex;
    private DefaultMarathonDataModel model;
    private List childFrames;
    JMenu menuLevel = new JMenu("Level");
    JMenu menuMode = new JMenu("Mode");
    MapCanvas canvas;
    ProgressBarDialog progressBarDialog;
    private int editMode;
    private static final long serialVersionUID = 1L;

    public MainViewFrame() {
        this.model = new DefaultMarathonDataModel(this);
        this.childFrames = new ArrayList();
        this.canvas = new MapCanvas(this);
        this.jbInit();
    }

    private void jbInit() {
        this.setDefaultCloseOperation(3);
        this.setLocationByPlatform(true);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.setupMenuBar(menuBar);
        this.canvas.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.getContentPane().add(this.canvas);
        this.progressBarDialog = new ProgressBarDialog(this);
    }

    private void setupMenuBar(JMenuBar menuBar) {
        JMenu menuFile = new JMenu("File");
        JMenuItem miOpen = new JMenuItem("Open");
        JMenuItem miSave = new JMenuItem("Save");
        JMenuItem miSaveAs = new JMenuItem("SaveAs ...");
        JMenuItem miExit = new JMenuItem("Exit");
        menuBar.add(menuFile);
        menuFile.add(miOpen);
        menuFile.add(miSave);
        menuFile.add(miSaveAs);
        menuFile.addSeparator();
        menuFile.add(miExit);
        miOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainViewFrame.this.doMenuItemOpen(e);
            }
        });
        miSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainViewFrame.this.doMenuItemSave(e);
            }
        });
        miSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainViewFrame.this.doMenuItemSaveAs(e);
            }
        });
        miExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainViewFrame.this.doMenuItemExit(e);
            }
        });
        JMenu menuEdit = new JMenu("Edit");
        JMenuItem miPreferences = new JMenuItem("Preferences");
        menuBar.add(menuEdit);
        menuEdit.add(miPreferences);
        miPreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainViewFrame.this.doMenuItemPreference(e);
            }
        });
        this.menuLevel.setEnabled(false);
        menuBar.add(this.menuLevel);
        JMenuItem miSelectLevel = new JMenuItem("Select level");
        JMenuItem miItemPlacement = new JMenuItem("Item placement");
        JMenuItem miMonsterPlacement = new JMenuItem("Monster placement");
        this.menuLevel.add(miSelectLevel);
        this.menuLevel.addSeparator();
        this.menuLevel.add(miItemPlacement);
        this.menuLevel.add(miMonsterPlacement);
        miSelectLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainViewFrame.this.doMenuItemSelectLevel(e);
            }
        });
        this.menuMode.setEnabled(false);
        menuBar.add(this.menuMode);
        JMenuItem miDrawMode = new JMenuItem("Draw mode");
        JMenuItem miVisualMode = new JMenuItem("Visual mode");
        JMenuItem miPolygonTypeMode = new JMenuItem("Polygon type mode");
        JMenu miElevationMode = new JMenu("Elevation mode");
        JMenuItem miiElevationFloor = new JMenuItem("Floor");
        JMenuItem miiElevationCeiling = new JMenuItem("Ceiling");
        JMenu miLightMode = new JMenu("Light mode");
        JMenuItem miiLightFloor = new JMenuItem("Floor");
        JMenuItem miiLightCeiling = new JMenuItem("Ceiling");
        JMenu miSoundMode = new JMenu("Sound mode");
        JMenuItem miiSoundFloor = new JMenuItem("Floor");
        JMenuItem miiSoundCeiling = new JMenuItem("Ceiling");
        JMenu miTextureMode = new JMenu("Texture mode");
        JMenuItem miiTextureFloor = new JMenuItem("Floor");
        JMenuItem miiTextureCeiling = new JMenuItem("Ceiling");
        this.menuMode.add(miDrawMode);
        this.menuMode.add(miVisualMode);
        this.menuMode.addSeparator();
        this.menuMode.add(miPolygonTypeMode);
        this.menuMode.add(miElevationMode);
        ((Container)miElevationMode).add(miiElevationFloor);
        ((Container)miElevationMode).add(miiElevationCeiling);
        this.menuMode.add(miLightMode);
        ((Container)miLightMode).add(miiLightFloor);
        ((Container)miLightMode).add(miiLightCeiling);
        this.menuMode.add(miSoundMode);
        ((Container)miSoundMode).add(miiSoundFloor);
        ((Container)miSoundMode).add(miiSoundCeiling);
        this.menuMode.add(miTextureMode);
        ((Container)miTextureMode).add(miiTextureFloor);
        ((Container)miTextureMode).add(miiTextureCeiling);
        miVisualMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainViewFrame.this.doMenuItemVisualMode(e);
            }
        });
    }

    private void doMenuItemVisualMode(ActionEvent e) {
        VisualModeDialog dlg = new VisualModeDialog(this, this.model.getMapData().getLevel(this.getLevelIndex()));
        dlg.setVisible(true);
    }

    private void doMenuItemSaveAs(ActionEvent e) {
    }

    private void doMenuItemSave(ActionEvent e) {
    }

    private void doMenuItemSelectLevel(ActionEvent e) {
        SelectLevelDialog dlg = new SelectLevelDialog(this, this.model.getMapData().getLevels());
        dlg.setVisible(true);
    }

    private void doMenuItemPreference(ActionEvent e) {
    }

    private void doMenuItemOpen(ActionEvent e) {
        int retVal;
        String openFilePath = "";
        JFileChooser fc = new JFileChooser();
        Preferences preferences = Preferences.getInstance();
        String path = preferences.get("MapDefaultPath");
        try {
            if (!path.equals("")) {
                fc.setCurrentDirectory(new File(path));
            }
        }
        catch (Exception e1) {
            System.out.println(e);
            fc.setCurrentDirectory(new File("user.dir"));
        }
        if ((retVal = fc.showOpenDialog(this)) == 0) {
            openFilePath = fc.getSelectedFile().getPath();
        } else if (retVal == 1) {
            return;
        }
        this.setTitle("Map Viewer (Powered by JUICE) - " + fc.getSelectedFile().getName());
        this.turnProgOn();
        this.progressBarDialog.start(new ProgressLoadThread(this.model, openFilePath));
    }

    private void doMenuItemExit(ActionEvent e) {
        System.exit(0);
    }

    public void addChildFrame(JFrame frm) throws Exception {
        this.childFrames.add(frm);
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public void initLoad() throws Exception {
        this.loadLevel(0);
        this.menuLevel.setEnabled(true);
        this.menuMode.setEnabled(true);
    }

    private void loadLevel(int levelIndex2) {
        System.out.println("Get level #" + levelIndex2);
        this.levelIndex = levelIndex2;
        this.getCanvas().setLevel(this.model.getMapData().getLevel(levelIndex2));
    }

    public void removeChildFrame(JFrame frm) throws Exception {
        if (this.childFrames.contains(frm)) {
            this.childFrames.remove(frm);
        }
    }

    private void setAllEnable(boolean enable) {
        this.setEnabled(enable);
        Iterator it = this.childFrames.iterator();
        while (it.hasNext()) {
            ((JFrame)it.next()).setEnabled(enable);
        }
        if (enable) {
            this.setVisible(true);
        }
    }

    public void turnProgOn() {
        this.progressBarDialog.setVisible(true);
        this.setAllEnable(false);
    }

    public void turnProgOff() {
        this.progressBarDialog.setVisible(false);
        this.setAllEnable(true);
    }

    public MapCanvas getCanvas() {
        return this.canvas;
    }

    protected int getEditMode() {
        return this.editMode;
    }

    protected void setEditMode(int editMode) {
        this.editMode = editMode;
    }

    public void setCameraCenter(int x, int y) {
        int[] center = new int[]{x, y};
        this.canvas.setCameraPosition(center);
        this.repaint();
    }
}

