/*
 * graph2D
 * Copyright (c) 2011 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "textureContainer.h"
#include "component.h"

namespace Graph2D
{
	TextureContainer::TextureContainer()
	{
	}

	TextureContainer::~TextureContainer()
	{
		clear();
	}

	Texture* TextureContainer::load(const std::string& filename)
	{
		Texture* texture = NULL;
		if(Component::loadTextureCore(&texture, filename))
		{
			textures.push_back(texture);
		}
		return texture;
	}

	void TextureContainer::unload(Texture* texture)
	{
		Component::unloadTextureCore(&texture);
	}

	void TextureContainer::clear()
	{
		for(std::vector<Texture*>::iterator i = textures.begin(); i != textures.end(); i++)
		{
			unload(*i);
		}
		textures.clear();
	}
}
