/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_STOPWATCH_H___)
#define ___GRAPH2D_STOPWATCH_H___

#if defined(TARGET_WINDOWS)
#include <windows.h>
#elif defined(TARGET_IPHONE)
#include "platform/iOS/stopwatch_impl.h"
#else
#include <sys/time.h>
#endif

namespace Graph2D
{
	class Stopwatch
	{
	public:
		Stopwatch()
		{
			start();
		}

		void start()
		{
			startTime = now();
		}

		float stop() const
		{
			return static_cast<float>(now() - startTime);
		}

		static double now()
		{
#if defined(TARGET_WINDOWS)
			LARGE_INTEGER frequency, counter;

			if(!QueryPerformanceFrequency(&frequency) || !QueryPerformanceCounter(&counter))
				return 0.0;

			return static_cast<double>(counter.QuadPart) / static_cast<double>(frequency.QuadPart);

#elif defined(TARGET_IPHONE)
			return Implementation::Stopwatch::now();
#else
			struct timeval current;
			return (gettimeofday(&current, NULL) == 0) ? static_cast<double>(current.tv_sec) * 1e-6 : 0;
#endif
		}

	protected:
		double startTime;
	};
}

#endif
