/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPHC2D_SCENE_H___)
#define ___GRAPHC2D_SCENE_H___

#include "container.h"
#include "window.h"
#include "particleManager.h"
#include "vector2.h"
#include <mana.h>

#define DEFAULT_FADE_TIME	0.5f
#define MESSAGE_LAYER		1

namespace Graph2D
{
	class MessageWindow;
	class TextWindow;
	class ParticleManager;

	class Scene : public Container
	{
		DISALLOW_COPY_AND_ASSIGN(Scene);

		typedef Container super;

	protected:
		unsigned int sceneType;
		unsigned int state;

		MessageWindow* messageWindow;
		TextWindow* textWindow;

		Window* dialog;
		float fadeColor;
		float fadeDeltaColor;
		float fadeTargetColor;
		float fadeColorTime;
		bool fadeColorEnable;

		ParticleManager* particleManager;

		std::string scriptProgramFileName;		//!< スクリプトファイル名
		Data* scriptProgram;					//!< スクリプト実行プログラム
		mana* script;							//!< スクリプト

	protected:
		virtual ~Scene();

	public:
		Scene(const unsigned int sceneType = ~0);

		virtual const char* getTypeName() const
		{
			return "Scene";
		}

		unsigned int getSceneType() const
		{
			return sceneType;
		}

		const char* getSceneName() const
		{
			return "DefaultScene";
		}

		unsigned int getState() const
		{
			return state;
		}

		void setState(const unsigned int state);

		MessageWindow* getMessageWindow();
		const MessageWindow* getMessageWindow() const
		{
			return getMessageWindow();
		}

		TextWindow* getTextWindow();
		const TextWindow* getTextWindow() const
		{
			return getTextWindow();
		}

		Window* getDialog()
		{
			return dialog;
		}
		const Window* getDialog() const
		{
			return getDialog();
		}
		void setDialog(Window* dialog, const bool centering);

		ParticleManager* getParticleManager();

		float fadein(const float second = DEFAULT_FADE_TIME) const;
		float fadeout(const float second = DEFAULT_FADE_TIME) const;

		bool loadScript(const std::string& filename);	//!< スクリプトを読み込みます
		void unloadScript();							//!< スクリプトを開放します
		mana* getScript();								//!< スクリプトを取得します

		virtual void onSerialize(mana_stream* stream) const;
		virtual void onDeserialize(mana_stream* stream);
		virtual void onDestroy(Component* component);
		virtual void onUpdate(const UpdateInfomation& updateInfomation);
		virtual void onDraw(const DrawRect& drawRect);

		virtual bool touchesBegan(const Vector2& localPosition);
		virtual bool touchesMoved(const Vector2& localPosition);
		virtual bool touchesEnded(const Vector2& localPosition);
		virtual bool touchesCancelled(const Vector2& localPosition);

		virtual bool onPrepare()
		{
			return true;
		}
		virtual void onInitialize(){}
		virtual void onFinalize(){}

		virtual bool compare(const Scene& other) const;

	protected:
		void fade(const float alpha, const float second = 0.8f);
	};
}

#endif
