/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_TEXTURE2D_H___)
#define ___GRAPH2D_TEXTURE2D_H___

#if 0
#include "../common.h"
#include "../graphicDevice.h"
#include "../vector2.h"
#include <string>

namespace Graph2D
{
	class Texture2D
	{
		GLuint name;
		unsigned int width, height;
		GLfloat maxS, maxT;

		Vector2 dimensions;
		int alignment;

		wchar_t* pwcMessage;
		unsigned int messageDisplayListId;
		int messageDisplayListSize;
		INT* characterWidth;
		INT characterHeight;

	public:
		Texture2D();
		//Texture2D();
		explicit Texture2D(const std::string& string, const Vector2& dimensions, const int alignment, const LOGFONT fontName);
		explicit Texture2D(const wchar_t* string, const Vector2& dimensions, const int alignment, const LOGFONT fontName);
		~Texture2D();

		void drawAtPoint(const Vector2& point);

		GLuint getName() const
		{
			return name;
		}

		Vector2 getSize() const
		{
			return Vector2(static_cast<float>(width), static_cast<float>(height));
		}

		Vector2 getTextureSize() const
		{
			return dimensions;
		}

		Vector2 getMaxSize() const
		{
			return Vector2(maxS, maxT);
		}

	private:
		void initialize();
		void create(const wchar_t* string, const Vector2& dimensions, const int alignment, const LOGFONT fontName);
	};
}
#endif
#endif
