/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "texture2D.h"
#if 0

// GDI plusを利用してみたらどうだろう
// http://www21.atwiki.jp/opengl/pages/25.html
namespace Graph2D
{
	Texture2D::Texture2D()
	{
		initialize();
	}

#if 0
	Texture2D::Texture2D()
	{
		GLint saveName;
		glGenTextures(1, &name);
		glGetIntegerv(GL_TEXTURE_BINDING_2D, &saveName);
		glBindTexture(GL_TEXTURE_2D, name);
		
		glBindTexture(GL_TEXTURE_2D, saveName);
	
		size = size;
		width = width;
		height = height;
		format = pixelFormat;
		maxS = size.width / (float)width;
		maxT = size.height / (float)height;
	}
#endif

	Texture2D::Texture2D(const std::string& string, const Vector2& dimensions, const int alignment, const LOGFONT fontName)
	{
		initialize();

		messageDisplayListSize = MultiByteToWideChar(CP_ACP, 0, string.c_str(), -1, NULL, 0);
		if(messageDisplayListSize > 0)
		{
			wchar_t* pwcMessage = new wchar_t[messageDisplayListSize];
			if(pwcMessage)
			{
				MultiByteToWideChar(CP_ACP, 0, string.c_str(), -1, pwcMessage, messageDisplayListSize);
				create(pwcMessage, dimensions, alignment, fontName);
				delete[] pwcMessage;
			}
		}
	}

	Texture2D::Texture2D(const wchar_t* string, const Vector2& dimensions, const int alignment, const LOGFONT fontName)
	{
		initialize();

		create(string, dimensions, alignment, fontName);
	}

	Texture2D::~Texture2D()
	{
		if(name)
		{
			glDeleteTextures(1, &name);
			//name = 0;
		}
		if(messageDisplayListSize > 0)
		{
			glDeleteLists(messageDisplayListId, messageDisplayListSize);
			//messageDisplayListId = 0;
			//messageDisplayListSize = 0;
		}
		if(characterWidth)
		{
			delete[] characterWidth;
			//characterWidth = NULL;
			//characterHeight = 0;
		}
	}

	void Texture2D::initialize()
	{
		name = 0;
		pwcMessage = NULL;
		messageDisplayListId = 0;
		messageDisplayListSize = 0;
		characterWidth = NULL;
	}

	void Texture2D::create(const wchar_t* string, const Vector2& dimensions, const int alignment, const LOGFONT fontName)
	{
		messageDisplayListSize = wcslen(string);

		// ディスプレーリストを作成
		messageDisplayListId = glGenLists(messageDisplayListSize);

		// 文字の幅リストを作成
		characterWidth = new INT[messageDisplayListSize];

		// 文字の幅とビットマップデータを作成
		HDC hDC = wglGetCurrentDC();
		HFONT hFont = CreateFontIndirect(&fontName);
		HFONT hOldFont = (HFONT)SelectObject(hDC, hFont);

		const LONG fontWidth = (fontName.lfWidth > 0) ? fontName.lfWidth : -fontName.lfWidth;
		const LONG fontHeight = (fontName.lfHeight > 0) ? fontName.lfHeight : -fontName.lfHeight;

		width = 0;
		height = fontHeight;

		for(int i = 0; i < messageDisplayListSize; i++)
		{
			// 文字の幅を取得
			const wchar_t wcCharacter = pwcMessage[i];
			if(!GetCharWidth32W(hDC, wcCharacter, wcCharacter, &characterWidth[i]))
				characterWidth[i] = fontWidth;
			width += characterWidth[i];

			// 文字のビットマップを作成
			while(!wglUseFontBitmapsW(hDC, wcCharacter, 1, messageDisplayListId + i))
				;

			// @todo:アライメント調整
		}

		characterHeight = fontHeight;

		SelectObject(hDC, hOldFont);
		DeleteObject(hFont);
	}

	void Texture2D::drawAtPoint(const Vector2& point)
	{
		if(messageDisplayListSize > 0)
		{
			int x = static_cast<int>(point.x);
			int y = static_cast<int>(point.y);
/*
			if(textAlignment == TA_CENTER_)
				x +=(width - width) / 2;
			else if(textAlignment == TA_RIGHT_)
				x +=(width - width);
*/
			for(GLsizei i = 0; i < messageDisplayListSize; i++)
			{
				GLuint code = messageDisplayListId + i;

				glRasterPos2i(x, y + characterHeight - 4);
				glCallList(code);

				x += characterWidth[i];
			}
		}
	}
#if 0
- (void) drawAtPoint:(CGPoint)point 
{
#if 0
	GLfloat		coordinates[] = {
		0.0f,	_maxT,
		_maxS,	_maxT,
		0.0f,	0.0f,
		_maxS,	0.0f
	};
#else
	GLfloat		coordinates[] = {
		0.0f,	0.0f,
		_maxS,	0.0f,
		0.0f,	_maxT,
		_maxS,	_maxT
	};
#endif
	GLfloat		width = (GLfloat)_width * _maxS,
				height = (GLfloat)_height * _maxT;

#if 0
	GLfloat		vertices[] = {	-width / 2 + point.x,	-height / 2 + point.y,	0.0f,
								width / 2 + point.x,	-height / 2 + point.y,	0.0f,
								-width / 2 + point.x,	height / 2 + point.y,	0.0f,
								width / 2 + point.x,	height / 2 + point.y,	0.0f };
	
#else // anchor is done by cocos2d automagically
	GLfloat		vertices[] = {	point.x,			point.y,	0.0f,
								width + point.x,	point.y,	0.0f,
								point.x,			height  + point.y,	0.0f,
								width + point.x,	height  + point.y,	0.0f };
#endif
	
	glBindTexture(GL_TEXTURE_2D, _name);
	glVertexPointer(3, GL_FLOAT, 0, vertices);
	glTexCoordPointer(2, GL_FLOAT, 0, coordinates);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
}


- (void) drawInRect:(CGRect)rect
{
	GLfloat	 coordinates[] = {
		0.0f,	0.0f,
		_maxS,	0.0f,
		0.0f,	_maxT,
		_maxS,	_maxT
	};
	GLfloat	vertices[] = {	rect.origin.x,							rect.origin.y,							/*0.0f,*/
							rect.origin.x + rect.size.width,		rect.origin.y,							/*0.0f,*/
							rect.origin.x,							rect.origin.y + rect.size.height,		/*0.0f,*/
							rect.origin.x + rect.size.width,		rect.origin.y + rect.size.height,		/*0.0f*/ };
	
	glBindTexture(GL_TEXTURE_2D, _name);
	glVertexPointer(2, GL_FLOAT, 0, vertices);
	glTexCoordPointer(2, GL_FLOAT, 0, coordinates);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
}
#endif
}
#endif