/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "data_impl.h"
#include "soundPlayer_impl.h"

namespace Graph2D
{
	namespace Implementation
	{
		namespace Sound
		{
			bool load(const size_t bufferName, const std::string& filename)
			{
				return false;
			}
#if 0
			////////////////////////////////////////////////////////////////////////////////
			// async
			////////////////////////////////////////////////////////////////////////////////
			typedef struct Environment
			{
				AudioStreamBasicDescription format;
				ExtAudioFileRef file;
			}Environment;

			void* open(const std::string& filename)
			{
				Environment* self = reinterpret_cast<Environment*>(g2d_malloc(sizeof(Environment)));
				if(self)
				{
					NSString* name = [NSString stringWithUTF8String:filename.c_str()];
					
					// リソースのURLを作成
					CFURLRef url = (CFURLRef)[DataController getResouceUriWithString:name];

					// オーディオファイルを開く
					if(ExtAudioFileOpenURL(url, &self->file))
						goto ABORT;

					// オーディオデータフォーマットを取得する
					AudioStreamBasicDescription inputFormat;
					UInt32 size = sizeof(inputFormat);
					if(ExtAudioFileGetProperty(self->file, kExtAudioFileProperty_FileDataFormat, &size, &inputFormat))
						goto ABORT;

					// アウトプットフォーマットを設定する
					self->format.mSampleRate = inputFormat.mSampleRate;
					self->format.mChannelsPerFrame = inputFormat.mChannelsPerFrame;
					self->format.mFormatID = kAudioFormatLinearPCM;
					self->format.mBytesPerPacket = 2 * self->format.mChannelsPerFrame;
					self->format.mFramesPerPacket = 1;
					self->format.mBytesPerFrame = 2 * self->format.mChannelsPerFrame;
					self->format.mBitsPerChannel = 16;
					self->format.mFormatFlags = kAudioFormatFlagsNativeEndian|kAudioFormatFlagIsPacked|kAudioFormatFlagIsSignedInteger;
					if(ExtAudioFileSetProperty(self->file, kExtAudioFileProperty_ClientDataFormat, sizeof(self->format), &self->format))
						goto ABORT;
				}
				return self;

ABORT:
				close(self);
				return NULL;
			}
			
			unsigned int channels(void* self)
			{
				Environment* environment = reinterpret_cast<Environment*>(self);
				return environment ? environment->format.mChannelsPerFrame : 0;
			}
			
			bool read(void* self, void* buffer, size_t& size)
			{
				Environment* environment = reinterpret_cast<Environment*>(self);
				if(environment)
				{
					// バッファを用意する
					AudioBufferList dataBuffer;

					dataBuffer.mNumberBuffers = 1;
					dataBuffer.mBuffers[0].mDataByteSize = size;
					dataBuffer.mBuffers[0].mNumberChannels = environment->format.mChannelsPerFrame;
					dataBuffer.mBuffers[0].mData = buffer;

					// バッファにデータを読み込む
					UInt32 fileLengthFrames;
					ExtAudioFileRead(environment->file, &fileLengthFrames, &dataBuffer) == errSecSuccess;
				}
			}
			
			void rewind(void* self)
			{
				Environment* environment = reinterpret_cast<Environment*>(self);
				if(environment)
				{
				}
			}
			
			void close(void* self)
			{
				Environment* environment = reinterpret_cast<Environment*>(self);
				if(environment)
				{
					// オーディオファイルを破棄する
					if(environment->file)
						ExtAudioFileDispose(environment->file);
				}

				// バッファを解放
				g2d_free(self);
			}
#endif
		}
	}
}
