/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#define INCLUDE_FROM_OBJC_C

#include "data_impl.h"
#include "texture_impl.h"
#include "PVRTCLoader.h"
#include "Texture2D.h"
#include <cassert>

namespace Graph2D
{
	namespace Implementation
	{
		namespace Texture
		{
			void* load(const std::string& filename, const bool compressed)
			{
				void* result = NULL;

				NSString* file = [NSString stringWithUTF8String:filename.c_str()];
				NSString* path = [DataController getResoucePathWithString:file];
				if(compressed)
				{
					result = new PVRTCLoader([path UTF8String]);
				}
				else
				{
					NSData* data = [[NSData alloc] initWithContentsOfFile:path];
					if(data)
					{
						UIImage* image = [[UIImage alloc] initWithData:data];
						if(image)
						{
							result = [[Texture2D alloc] initWithImage:image];

							[image release];
						}

						[data release];
					}
				}

				return result;
			}

			void unload(void* self, const bool compressed)
			{
				if(self)
				{
					if(compressed)
					{
						PVRTCLoader* instance = reinterpret_cast<PVRTCLoader*>(self);
						delete instance;
					}
					else
					{
						Texture2D* instance = reinterpret_cast<Texture2D*>(self);
						[instance release];
					}
				}
			}

			GLuint getName(void* self, const bool compressed)
			{
				assert(self);
				if(compressed)
				{
					PVRTCLoader* instance = reinterpret_cast<PVRTCLoader*>(self);
					return instance->getName();
				}
				else
				{
					Texture2D* instance = reinterpret_cast<Texture2D*>(self);
					return instance.name;
				}
			}

			Vector2 getSize(void* self, const bool compressed)
			{
				assert(self);
				if(compressed)
				{
					PVRTCLoader* instance = reinterpret_cast<PVRTCLoader*>(self);
					return Vector2(instance->getWidth(), instance->getHeight());
				}
				else
				{
					Texture2D* instance = reinterpret_cast<Texture2D*>(self);
					return Vector2(instance.contentSize.width, instance.contentSize.height);
				}
			}

			Vector2 getTextureSize(void* self, const bool compressed)
			{
				assert(self);
				if(compressed)
				{
					PVRTCLoader* instance = reinterpret_cast<PVRTCLoader*>(self);
					return Vector2(instance->getWidth(), instance->getHeight());
				}
				else
				{
					Texture2D* instance = reinterpret_cast<Texture2D*>(self);
					return Vector2(static_cast<float>(instance.pixelsWide), static_cast<float>(instance.pixelsHigh));
				}
			}

			Vector2 getMaxSize(void* self, const bool compressed)
			{
				assert(self);
				if(compressed)
				{
					PVRTCLoader* instance = reinterpret_cast<PVRTCLoader*>(self);
					return Vector2(instance->getWidth(), instance->getHeight());
				}
				else
				{
					Texture2D* instance = reinterpret_cast<Texture2D*>(self);
					return Vector2(instance.maxS, instance.maxT);
				}
			}
		}
	}
}

