/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPHC2D_TEXT_IMPL_H___)
#define ___GRAPHC2D_TEXT_IMPL_H___

#include <string>

namespace Graph2D
{
	namespace Implementation
	{
		namespace Text
		{
			namespace Cache
			{
				void initialize(const size_t size);
				void finalize();
			}
			void* create();
			void* create(const size_t fontSize);
			void* create(const std::string& fontName, const size_t fontSize);
			void release(void* self);

			GLuint getName(void* self);

			size_t getFontSize(void* self);
			void setFontSize(void* self, const size_t fontSize);

			const char* getFontName(void* self);
			void setFontName(void* self, const std::string& fontName);

			void setAlignment(void* self, const unsigned char alignment);
			void set(void* self, const size_t width, const size_t height, const std::string& text);

			Vector2 getSize(void* self, const std::string& text);

			void draw(void* self, const Vector2& position, const Vector2& size);
		}
	}
}

#endif
