#if !defined(___PVRTC_LOADER_H___)
#define ___PVRTC_LOADER_H___

#include <OpenGLES/ES1/gl.h>
#include <OpenGLES/ES1/glext.h>

namespace Graph2D
{
	namespace Implementation
	{
		class PVRTCLoader
		{
		public:
			enum Constants
			{
				PVRTC_FLAG_TYPE_PVRTC_2 = 24,
				PVRTC_FLAG_TYPE_PVRTC_4 = 25,
				PVRTC_FLAG_TYPE_MASK    = 0xff,
				PVRTC_MAX_SURFACES      = 16
			};

			struct Header
			{
				unsigned int headerSize;
				unsigned int height;
				unsigned int width;
				unsigned int numMipmaps;
				unsigned int flags;
				unsigned int dataSize;
				unsigned int bpp;
				unsigned int bitmaskRed;
				unsigned int bitmaskGreen;
				unsigned int bitmaskBlue;
				unsigned int bitmaskAlpha;
				unsigned int tag;
				unsigned int numSurfaces;
			};

			struct Surface
			{
				GLuint size;
				const void* bits;
			};

		private:
			GLuint width;
			GLuint height;
			GLuint name;
			GLenum format;
			bool alpha;
			Surface surfaces[PVRTC_MAX_SURFACES];
			GLuint numSurfaces;
			char* readBuffer;

			static const char PVRIdentifier[4];

		public:
			PVRTCLoader();
			PVRTCLoader(const char* path);
			~PVRTCLoader();

			bool loadFromFile(const char* path);
			bool loadFromMemory(const void* pData);

			GLuint getWidth() const
			{
				return width;
			}

			GLuint getHeight() const
			{
				return height;
			}

			GLenum getFormat() const
			{
				return format;
			}

			bool hasAlpha() const
			{
				return alpha;
			}

			GLuint getSurfaceCount() const
			{
				return numSurfaces;
			}

			GLuint getName() const
			{
				return name;
			}
		};
	}
}

#endif
