/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPHC2D_AUDIO_PLAYER_IMPL_H___)
#define ___GRAPHC2D_AUDIO_PLAYER_IMPL_H___

#include <string>

namespace Graph2D
{
	namespace Implementation
	{
		namespace AudioPlayer
		{
			void* play(const std::string& filename);
			void stop(void* self);
			void pause(void* self, const bool on);
			void release(void* self);
			bool playing(void* self);
			float addVolume(void* self, const float offset);
			float getVolume(void* self);
			void setVolume(void* self, const float vol);
			void setLoopCount(void* self, const int numberOfLoops);
			double getCurrentTime(void* self);
			void setCurrentTime(void* self, const double second);
		}
	}
}

#endif
