/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_PARTICLE_MANAGER_H___)
#define ___GRAPH2D_PARTICLE_MANAGER_H___

#include "base.h"
#include "particle.h"

namespace Graph2D
{
	struct UpdateInfomation;

	class ParticleManager : public Base
	{
		DISALLOW_COPY_AND_ASSIGN(ParticleManager);

		typedef Base super;

		Particle* freeParticleList;
		Particle* activeParticleList;

	protected:
		virtual ~ParticleManager();

	public:
		ParticleManager();
		explicit ParticleManager(const unsigned int hint);

		Particle* popFreeParticle();
		void pushFreeParticle(Particle* particle);

		void activate(Particle* particle);

		virtual void onUpdate(const UpdateInfomation& updateInfomation);
	};
}


#endif
