/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "particleManager.h"

namespace Graph2D
{
	ParticleManager::ParticleManager()
	{
	}

	ParticleManager::ParticleManager(const unsigned int hint)
	{
		activeParticleList = NULL;
		freeParticleList = NULL;

		for(unsigned int i = 0; i < hint; i++)
		{
			Particle* particle = new Particle();
			particle->setIndex(static_cast<unsigned short>(i));
			particle->setNext(freeParticleList);
			freeParticleList = particle;
		}
	}

	ParticleManager::~ParticleManager()
	{
		Particle* particle;

		particle = activeParticleList;
		while(particle)
		{
			Particle* next = particle->getNext();
			particle->release();
			particle = next;
		}

		particle = freeParticleList;
		while(particle)
		{
			Particle* next = particle->getNext();
			particle->release();
			particle = next;
		}
	}

	Particle* ParticleManager::popFreeParticle()
	{
		Particle* particle = freeParticleList;
		freeParticleList = particle->getNext();
		particle->setNext(NULL);
		return particle;
	}

	void ParticleManager::pushFreeParticle(Particle* particle)
	{
		particle->setNext(freeParticleList);
		freeParticleList = particle;
	}

	void ParticleManager::activate(Particle* particle)
	{
		particle->setNext(activeParticleList);
		activeParticleList = particle;
	}

	void ParticleManager::onUpdate(const UpdateInfomation& updateInfomation)
	{
		(void)updateInfomation;

		// 寿命がつきたパーティクルを回収します
		Particle** lastParticleLink = &activeParticleList;
		Particle* particle = activeParticleList;
		while(particle)
		{
			if(particle->getLife() <= 0.0f)
			{
				Particle* nextParticle = particle->getNext();

				particle->removeFromParent();

				*lastParticleLink = nextParticle;

				pushFreeParticle(particle);

				particle = nextParticle;
			}
			else
			{
				lastParticleLink = &particle->next;
				particle = particle->getNext();
			}
		}
	}
}
