/*
 * graph2D
 * Copyright (c) 2011 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPHC2D_MESSAGE_WINDOW_H___)
#define ___GRAPHC2D_MESSAGE_WINDOW_H___

#include "message.h"
#include "window.h"
#include <cstdarg>

namespace Graph2D
{
	class MessageWindow : public Window
	{
		DISALLOW_COPY_AND_ASSIGN(MessageWindow);

		typedef Window super;

		Message* message;

	protected:
		virtual ~MessageWindow();

	public:
		MessageWindow();

		virtual const char* getTypeName() const
		{
			return "MessageWindow";
		}

		void clear();

		const std::string& getString() const;
		void setString(const std::string& text);
		void replace(const char* key, const char* word);

		Message* getMessage();
		const Message* getMessage() const;

		void format(const char* format, ...);
		void vformat(const char* format, va_list ap);

		const Color& getTextColor() const;
		void setTextColor(const Color& color);
		void setTextColor(const float r, const float g, const float b, const float a);

		float getTimer() const;
		void setTimer(const float timer);

		float getDelayTimer() const;
		void setDelayTimer(const float delayTimer);

		bool finished() const;

		virtual void onSizeChanged();
	};
}

#endif
