/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPHC2D_MESSAGE_H___)
#define ___GRAPHC2D_MESSAGE_H___

#include "container.h"
#include <cstdarg>
#include <string>

namespace Graph2D
{
	class Text;

	class Message : public Container
	{
		DISALLOW_COPY_AND_ASSIGN(Message);

		typedef Container super;

	protected:
		std::string message;
		Text* text;
		float wait;
		float timer;
		float delayWait;
		float delayTimer;
		unsigned int length;
		bool clicked;

	protected:
		virtual ~Message();

	public:
		Message();

		virtual const char* getTypeName() const
		{
			return "Message";
		}

		void clear();

		const std::string& getString() const;
		void setString(const std::string& message);

		void format(const char* format, ...);
		void vformat(const char* format, va_list ap);

		void replace(const char* key, const char* word);

		const Color& getTextColor() const;
		void setTextColor(const Color& color);
		void setTextColor(const float r, const float g, const float b, const float a);

		Text& getText();
		const Text& getText() const;

		float getTimer() const;
		void setTimer(const float timer);

		float getDelayTimer() const;
		void setDelayTimer(const float delayTimer);

		bool finished() const;

		virtual void onSerialize(mana_stream* stream) const;
		virtual void onDeserialize(mana_stream* stream);
		virtual void onUpdate(const UpdateInfomation& updateInfomation);
		virtual bool onTouchesEnded(const Vector2& mouse);
#if defined(DEBUG) || defined(_DEBUG) || defined(_DEBUG_) || !defined(NDEBUG)
		virtual void onDraw(const DrawRect& drawRect);
#endif
		virtual bool compare(const Message& other) const;
	};
}

#endif
