/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 * 
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 * 
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 * 
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "container.h"
#include "gridLayout.h"

namespace Graph2D
{
	GridLayout::GridLayout(const unsigned int collum, const unsigned int row)
	{
		this->collum = collum;
		this->row = row;

		if(this->collum <= 0)
			this->collum = 1;
		if(this->row <= 0)
			this->row = 1;
	}

	void GridLayout::apply(Container* container)
	{
		if(container == NULL)
			return;

		const Vector2 frameSize = container->getSize();
		const Vector2 cellSize = frameSize / Vector2(static_cast<float>(collum), static_cast<float>(row));

		unsigned int i = 0;
		for(float y = 0; y < frameSize.y; y += cellSize.y)
		{
			for(float x = 0; x < frameSize.x; x += cellSize.x)
			{
				Component* component = container->get(i);
				if(component)
				{
					component->setPosition(x, y);
					component->setSize(cellSize);
				}
				i++;
			}
		}
	}
}
