// 日本語

/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 * 
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 * 
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 * 
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#import "fileMenu.h"
#import "fileMenuButton.h"

enum FileMenuButtonID
{
	TITLE = 0,
	FILE0,
	FILE1,
	FILE2,
	FILE3,
	FILE4,
	FILE5,
	FILE6,
	FILE7,
	FILE8,
	FILE9,
	CLOSE,
	MAX
};

@implementation FileMenu

-(id)init
{
	if(self = [super init])
	{
		for(unsigned int i = TITLE; i < MAX; i++)
		{
			FileMenuButton* button = [[[FileMenuButton alloc] init] autorelease];
			switch(i)
			{
			case TITLE:
				[button setText:@"ファイルメニュー"];
				[button setPosition:Vector2(10, 10)];
				[button setSize:Vector2(480 - 10 * 2, 100)];
				break;

			case FILE0:
			case FILE1:
			case FILE2:
			case FILE3:
			case FILE4:
			case FILE5:
			case FILE6:
			case FILE7:
			case FILE8:
			case FILE9:
				{
					const float bx = (float)((int)i % 2) * 240 + 10;
					const float by = (float)((int)i / 2) * 50 + 120;
					[button setPosition:Vector2(bx, by)];
					[button setSize:Vector2(220, 30)];
				}
				break;

			case CLOSE:
				[button setText:@"ファイルメニュー"];
				[button setPosition:Vector2(480 - 50, 320 - 30)];
				[button setSize:Vector2(30, 20)];
				break;
			}
			[button setClickEvent:self];
			[button setData:i];

			[self set:static_cast<unsigned int>(i):button];
		}
	}
	return self;
}

-(void)dealloc
{
	[super dealloc];
}

-(void)onSerialize:(mana_stream*)stream
{
	[super onSerialize:stream];
}

-(void)onDeserialize:(mana_stream*)stream
{
	[super onDeserialize:stream];
}

-(void)onClick:(Component*)component
{
	switch([component getData])
	{
	case TITLE:
		break;

	case FILE0:
	case FILE1:
	case FILE2:
	case FILE3:
	case FILE4:
	case FILE5:
	case FILE6:
	case FILE7:
	case FILE8:
	case FILE9:
		break;

	case CLOSE:
		[self close];
		break;
	}
}

@end

