/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#include "emitter.h"
#include "particle.h"
#include "scene.h"
#include <cassert>
#include <cstdlib>

namespace Graph2D
{
	Emitter::Emitter()
	{
	}

	Emitter::Emitter(Scene* scene)
	{
		assert(scene);

		this->scene = scene;
		this->texture = NULL;
		this->cellAnimation = NULL;
		this->life = 1.0f;
		this->enable = false;
		this->intervalWait = (1.0f / 100.0f);
	}

	Emitter::~Emitter()
	{
		if(texture)
		{
			texture->release();
			texture = NULL;
		}

		if(cellAnimation)
		{
			cellAnimation->release();
			cellAnimation = NULL;
		}
	}

	void Emitter::onUpdate(const UpdateInfomation& updateInfomation)
	{
		ParticleManager* particleManager = scene->getParticleManager();

		if(enable)
		{
			life -= updateInfomation.deltaTime;
			if(life <= 0.0f)
				enable = false;
		}

		if(life > 0.0f)
		{
			intervalWait -= updateInfomation.deltaTime;
			if(intervalWait <= 0.0f)
			{
				do{
					Particle* particle = particleManager->popFreeParticle();
					if(particle)
					{
						const float RANDOM = static_cast<float>(rand() & 0x7FFF) / (32767.0f / 2.0f) - 1.0f;
						const float angle = 0.0f * (MANA_PI / 180.f);
						const float angleOffset = 25.0f * (MANA_PI / 180.f) * RANDOM;

						const float finalAngle = angle + angleOffset;
						const float initialSpeed = 88;

						const Vector2 velocity(sinf(finalAngle) * initialSpeed, -cosf(finalAngle) * initialSpeed);

						// パーティクルを初期化します
						particle->setGravity(Vector2(0.0f, 59.8f));
						particle->setVelocity(velocity);
						particle->setLife(2.0f);

						particle->setPosition(getPosition());
						particle->setSize(16.0f, 16.0f);
						particle->setColor(Color(1.0f, 1.0f, 1.0f, 1.0f), 0.0f);
						particle->setColor(Color(0.0f, 0.0f, 1.0f, 0.0f), 2.0f);
						particle->setTexture(getTexture());
						particle->addAnimation("particle", cellAnimation);
						particle->setAnimation("particle");
						particle->setVisible(true);

						scene->set(1000 + particle->getIndex(), particle);

						particleManager->activate(particle);
					}
					intervalWait += (1.0f / 100.0f);
				}while(intervalWait <= 0.0f);
				intervalWait = (1.0f / 100.0f);
			}
		}

		super::onUpdate(updateInfomation);
	}
}
