/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_CELL_ANIMATION_H___)
#define ___GRAPH2D_CELL_ANIMATION_H___

#include "base.h"
#include "vector2.h"

namespace Graph2D
{
	class CellAnimation : public Base
	{
		DISALLOW_COPY_AND_ASSIGN(CellAnimation);

		typedef Base super;

		Vector2 position;
		Vector2 size;
		float wait;
		unsigned short count;
		unsigned short loop;

	protected:
		~CellAnimation()
		{
		}

	public:
		CellAnimation() : wait(0), count(0), loop(0)
		{
		}

		explicit CellAnimation(const Vector2& position, const Vector2& size, const float wait, const unsigned short count, const unsigned short loop)
		{
			this->position = position;
			this->size = size;
			this->wait = wait;
			this->count = count;
			this->loop = loop;
		}

		const Vector2& getPosition() const
		{
			return position;
		}

		const Vector2& getSize() const
		{
			return size;
		}

		const float getWait() const
		{
			return wait;
		}

		unsigned short getCount() const
		{
			return count;
		}

		unsigned short getLoop() const
		{
			return loop;
		}

		float getLength() const
		{
			return wait * static_cast<float>(count);
		}
	};
}

#endif
