/*
 * graph2D
 * Copyright (c) 2009 Shun Moriya <shun126@users.sourceforge.jp>
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *  1. The origin of this software must not be misrepresented; you must not
 *     claim that you wrote the original software. If you use this software
 *     in a product, an acknowledgment in the product documentation would be
 *     appreciated but is not required.
 *
 *  2. Altered source versions must be plainly marked as such, and must not be
 *     misrepresented as being the original software.
 *
 *  3. This notice may not be removed or altered from any source
 *     distribution.
 */

#if !defined(___GRAPH2D_BUTTON_H___)
#define ___GRAPH2D_BUTTON_H___

#include "imageButton.h"
#include <cstdarg>
#include <string>

namespace Graph2D
{
	class Text;

	class Button : public ImageButton
	{
		DISALLOW_COPY_AND_ASSIGN(Button);

		typedef ImageButton super;

		Text* label;
		Text* tag;
		unsigned char textAlignmentH;
		unsigned char textAlignmentV;
		bool dirty:8;
		char padding;

	protected:
		virtual ~Button();
		void initialize();

	public:
		Button();
		explicit Button(const char* text);
		explicit Button(const std::string& text);

		virtual const char* getTypeName() const
		{
			return "Button";
		}

		void setSize(const Vector2& size);
		void setSize(const float w, const float h)
		{
			setSize(Vector2(w, h));
		}

		void adjustSize();

		const std::string& getString() const;
		void setString(const std::string& text);
		void format(const char* fmt, ...);

		void setFontSize(const float fontSize);

		//! ̃eLXgACg擾
		TextAlignmentH getTextAlignmentH() const;
		//! ̃eLXgACgݒ
		void setTextAlignmentH(const TextAlignmentH alignment);

		//! ̃eLXgACg擾
		TextAlignmentV getTextAlignmentV() const;
		//! ̃eLXgACgݒ
		void setTextAlignmentV(const TextAlignmentV alignment);

		void setTextColor(const Color& color);
		void setTextColor(const float r, const float g, const float b, const float a)
		{
			setTextColor(Color(r, g, b, a));
		}

		const std::string& getTagString() const;
		void setTagString(const std::string& text);
		void formatTag(const char* fmt, ...);
		void replace(const char* key, const char* word);

		virtual void onSerialize(mana_stream* stream) const;
		virtual void onDeserialize(mana_stream* stream);
		virtual void onUpdate(const UpdateInfomation& updateInfomation);
		virtual void onDraw(const DrawRect& drawRect);
		virtual bool onTouchesBegan(const Vector2& localPosition);
		virtual bool onTouchesEnded(const Vector2& localPosition);
		virtual bool onTouchesCancelled(const Vector2& localPosition);
		virtual void onSizeChanged();

		virtual bool compare(const Button& other) const;
	};
}

#endif
