# coding: UTF-8

#=設定された環境の XML-RPC を使って全ての記事を削除するツールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: delete_all_post.rb 830 2012-10-02 16:04:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../main/lib/")
$:.unshift(File.dirname(__FILE__) + "/../../main/")
$:.unshift(File.dirname(__FILE__) + "/../lib/")

# Mail2Weblog のルートパスを設定する
M2W_ROOT_PATH = File.dirname(__FILE__) + "/../../main"

require 'm2w_configurator'
require 'thread_pool'
require 'xmlrpc/client'
require 'xmlrpc_support/xmlrpc_parser'

client = M2W_WEBLOG_EXTENSION.client
thread_pool = ThreadPool.new(5)

# ブログ記事を投稿する
begin
	while true
		posts = client.call_async(
			"blogger.getRecentPosts",
			"",
			M2W_WEBLOG_DEFAULT_BLOGID,
			M2W_WEBLOG_USERNAME,
			M2W_WEBLOG_PASSWORD,
			100
		)

		if posts.size <= 0 then
			break
		end

		posts.each do |post|
			thread_pool.run do
				puts post
				p client.call_async(
					"blogger.deletePost",
					"",
					post['postid'],
					M2W_WEBLOG_USERNAME,
					M2W_WEBLOG_PASSWORD,
					0)
			end
		end

		thread_pool.join
	end
rescue XMLRPC::FaultException => e
  STDERR.puts "Error:"
  STDERR.puts e.faultCode
  STDERR.puts e.faultString
end
