# coding: UTF-8

require 'm2w_command'
require 'mailutils/mail_processor'

#=メールに関するテストユーティリティ
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: weblog_testutils.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class WeblogTestUtils

	attr_accessor :mail_parser
	attr_accessor :mail_sender
	attr_accessor :weblog
	attr_accessor :plugin_manager
	attr_accessor :mail_testutils
	attr_accessor :sender_mailaddress
	attr_accessor :receiver_mailaddress

	def initialize(weblog, mail_parser, mail_sender, plugin_manager, mail_testutils, sender_mailaddress, receiver_mailaddress)
		@weblog = weblog
		@mail_parser = mail_parser
		@mail_sender = mail_sender
		@plugin_manager = plugin_manager
		@mail_testutils = mail_testutils
		@sender_mailaddress = sender_mailaddress
		@receiver_mailaddress = receiver_mailaddress
	end

	def process_mail(mail)
		command = Mail2WeblogCommand.new(
			@weblog,
			@mail_parser,
			@mail_sender,
			@plugin_manager,
			-1)
		return command.process_mail(mail)
	end

	def post(blogid, header, content, attachments = [])
		from_address = MailAddress.new(@sender_mailaddress)
		to_addresses = [MailAddress.new(@receiver_mailaddress)]
		mail = Mail.new(@mail_sender.make_title("post", blogid), from_address, to_addresses, @mail_sender.make_content(header, content), attachments)

		command_adapter = Post_CommandAdapterPlugin4Mail.new
		command_adapter.mail_parser = @mail_parser
		command_adapter.plugin_manager = @plugin_manager
		command = Post_CommandPlugin.new
		command.weblog = @weblog
		command.plugin_manager = @plugin_manager
		response = command.run(command_adapter.create_request(command, mail))
		command_result = response.success
		mail = response.notices.size == 1 ? @mail_sender.make_mail_from_notice(response.notices[0]) : nil
		if command_result then
			return [command_result, mail, response[:postid], response[:attachment_urls]]
		else
			return [command_result, mail]
		end
	end

	def get(blogid, postid, header_alias = {})
		from_address = MailAddress.new(@sender_mailaddress)
		to_addresses = [MailAddress.new(@receiver_mailaddress)]
		header = {"postid" => postid}
		mail = Mail.new(@mail_sender.make_title("get", blogid), from_address, to_addresses, @mail_sender.make_content(header, nil))

		command_adapter = Get_CommandAdapterPlugin4Mail.new
		command_adapter.mail_parser = @mail_parser
		command_adapter.plugin_manager = @plugin_manager
		command = Get_CommandPlugin.new
		command.weblog = @weblog
		response = command.run(command_adapter.create_request(command, mail))
		command_result = response.success
		mail = response.notices.size == 1 ? @mail_sender.make_mail_from_notice(response.notices[0]) : nil
		if command_result then
			header = nil
			content = nil
			contents = nil
			case response[:mode]
			when 'wiki'
				(header, content, contents) = @mail_parser.parse_content(response[:original_content], header_alias)
			when 'html'
				(header, content, contents) = @mail_parser.parse_content(response[:original_html_content], header_alias, Mail2WeblogMailParserHtmlTextType.new)
			end
			header.delete(M2W_FORMAT_PLUGIN_CONF_HEADER_NAME)
			return [command_result, mail, header, content, contents, response[:attachments], response[:link]]
		else
			return [command_result, mail]
		end
	end

end
