# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../../../../")
	$:.unshift(ROOT_PATH + "/../../../../../main/")
	$:.unshift(ROOT_PATH + "/../../../../../main/lib/")

	# mail2weblog ̃[gpXݒ肷
	M2W_ROOT_PATH = ROOT_PATH + "/../../../../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

require 'plugin/weblog/lib/weblog_post_common'

require 'fileutils'

require File.expand_path("#{File.dirname(File.expand_path(__FILE__))}/conf/setting4weblog_post_common")

class MediaPoster4Test

	def initialize(media_name, thumbnail_name, thumbnail_setting)
		@content = File.open("#{File.dirname(File.expand_path(__FILE__))}/data/a.png", "rb") { |f| f.read }
		@media_name = media_name
		@thumbnail_name = thumbnail_name
		@thumbnail_setting = thumbnail_setting
	end

	def media_name
		return @media_name
	end

	def thumbnail_name
		return @thumbnail_name
	end

	def content
		return @content
	end

	def thumbnail_setting
		return @thumbnail_setting
	end

	def finish(media_url, thumbnail_url)
	end

end

#=uOLepʃW[̃eXg
#
# ŏ̒:: gDC[
# |Wg:: $Id: test_weblog_post_common.rb 795 2012-08-01 23:53:11Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class TestWeblogPostCommon < MiniTest::Unit::TestCase
	include WeblogPostCommon

	if M2W_SYSTEM_RMAGICK_SUPPORTED then
		# eXgp̃X^u
		def post_media(content, media_name, client, blogid, errors, warnings)
			@medias.push([media_name, content])
			return media_name
		end
		def test_post_medias
			tempdir = "#{File.dirname(File.expand_path(__FILE__))}/temp"
			if !Dir.exists?(tempdir) then
				FileUtils.makedirs(tempdir)
			end

			M2W4TEST_REAL_WEBLOG_POST_COMMON_MEDIA_POSTERS_DATA.each_with_index do |data, index|
				@medias = []
				@errors = []
				@warnings = []

				thumbnail_setting = {
					'condition_width' => data[0],
					'condition_height' => data[1],
					'scale' => data[2],
					'width' => data[3],
					'height' => data[4],
				}
				thumbnail_setting['keep'] = true if data[5]

				media_name = "#{index}.png"
				thumbnail_name = "thumb#{index}.png"
				media_posters = [MediaPoster4Test.new(media_name, thumbnail_name, thumbnail_setting)]

				post_medias(nil, nil, nil, nil, media_posters, @errors, @warnings)

				assert_equal data[6].size, @medias.size, data
				@medias.each_with_index do |media, index|
					File.open("#{tempdir}/#{media[0]}", "wb") { |f| f.write media[1] }
					image = Magick::Image.from_blob(media[1]).shift
					assert_equal data[6][index][0], image.columns, data
					assert_equal data[6][index][1], image.rows, data
				end

				assert_equal 0, @errors.size
				assert_equal 0, @warnings.size
			end
		end
	end

end
