# coding: UTF-8

require 'style/formatter'

M2W_WEBLOG_WORD_PRESS_LEFT_SQUARE_BRACKET = "&lsb;"
M2W_WEBLOG_WORD_PRESS_RIGHT_SQUARE_BRACKET = "&rsb;"

#=WordPress ̂߂̐ptH[}b^[
#
# ŏ̒:: gDC[
# |Wg:: $Id: word_press_formatter.rb 795 2012-08-01 23:53:11Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class WordPressFormatter < Formatter

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\[/, M2W_WEBLOG_WORD_PRESS_LEFT_SQUARE_BRACKET).gsub(/\]/, M2W_WEBLOG_WORD_PRESS_RIGHT_SQUARE_BRACKET)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_WORD_PRESS_LEFT_SQUARE_BRACKET, "[").gsub(M2W_WEBLOG_WORD_PRESS_RIGHT_SQUARE_BRACKET, "]")
		return CGI.unescapeHTML(result)
	end

end
