# coding: UTF-8

class AttachmentMediaPoster

	def initialize(attachment, attachment_index, media_name, thumbnail_name, vars)
		@attachment = attachment
		@attachment_index = attachment_index
		@media_name = media_name
		@thumbnail_name = thumbnail_name
		@vars = vars
	end

	def media_name
		return @media_name
	end

	def thumbnail_name
		return @thumbnail_name
	end

	def content
		return @attachment.content
	end

	def thumbnail_setting
		thumbnail_setting = __get_thumbnail_setting(@vars)
		if thumbnail_setting[@attachment_index] != nil then
			return thumbnail_setting[@attachment_index]
		else
			return nil
		end
	end

	def finish(media_url, thumbnail_url)
		@vars[:attachment_urls][@attachment_index] = media_url
		@vars[:thumbnail_urls][@attachment_index] = thumbnail_url if thumbnail_url != nil
	end

	def __get_thumbnail_setting(vars)
		M2W_LOGGER.debug("Start  #{self.class}#__get_thumbnail_setting ... vars = #{vars.to_s}")

		result = []
		if vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] != nil && vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME].has_key?(M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME) then
			M2W_LOGGER.debug("has thumbnail setting ... #{vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME].to_s}")
			vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME].each do |index, thumbnail_presetting|
				result[index.to_i] = thumbnail_presetting
			end
		end

		M2W_LOGGER.debug("Finish #{self.class}#__get_thumbnail_setting ... result = #{result.to_s}")
		return result
	end

end
