# coding: UTF-8

if $0 == __FILE__ then
	begin
		require 'rubygems'
	rescue LoadError
	end

	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/")
	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")
	$:.unshift(ROOT_PATH + "/../../main/lib")

	require 'minitest/autorun'
end

require 'open-uri'
require 'rsd/rsd_processor'

require "#{File.dirname(File.expand_path(__FILE__))}/conf/setting"

#=RSDProcessor のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_rsd.rb 675 2012-05-12 15:12:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestRSDProcessor < MiniTest::Unit::TestCase

	if REAL_TEST then
		def test_get_uri
			if HOME_PAGE != nil then
				content = nil
				open(HOME_PAGE) do |f|
					assert_equal RSD_URL, RSDProcessor.get_uri(f.read)
				end
			end
		end

		def test_parse
			rsd = nil
			open(RSD_URL) do |f|
				rsd = RSDProcessor.parse(f)
			end
			assert_equal RSD_ENGINE_NAME, rsd.engine_name
			assert_equal RSD_ENGINE_LINK, rsd.engine_link
			assert_equal RSD_HOME_PAGE_LINK, rsd.homepage_link

			assert_equal RSD_APIS.size, rsd.apis.size

			RSD_APIS.each do |api|
				name = api[0]
				assert_equal api[1], rsd.apis[name].preferred
				assert_equal api[2], rsd.apis[name].api_link
				assert_equal api[3], rsd.apis[name].blogid
			end
		end
	end

end
