# coding: UTF-8

class RelatedMediaPoster

	def initialize(related_attachment, media_name, thumbnail_name, plugin_manager, vars)
		@related_attachment = related_attachment
		@media_name = media_name
		@thumbnail_name = thumbnail_name
		@plugin_manager = plugin_manager
		@vars = vars
	end

	def media_name
		return @media_name
	end

	def thumbnail_name
		return @thumbnail_name
	end

	def content
		return @related_attachment.content
	end

	def thumbnail_setting
		setting = @plugin_manager.get_weblog_thumbnail_setting

		required_keys = ['condition_width', 'condition_height', 'scale']
		required_keys.each do |key|
			if !setting.has_key?(key) then
				return nil
			end
		end

		image = Magick::Image.from_blob(content).shift
		if image.columns > setting['condition_width'].to_i && image.rows > setting['condition_height'].to_i then
			return setting
		else
			return nil
		end
	end

	def finish(media_url, thumbnail_url)
		@vars[:related_attachment_urls][@related_attachment.content_id] = media_url
		@vars[:related_thumbnail_urls][@related_attachment.content_id] = thumbnail_url if thumbnail_url != nil
	end

end
