# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事取得コマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: get.rb 712 2012-05-26 02:05:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Get_CommandPlugin < StandardCommand

	def parse_mail_content
		content = @mail_parser.escaped_prefix_content(@mail.content, 'postid\.')
		(header, content, contents) = @mail_parser.parse_content(content, header_alias())
		return Mail2WeblogRequest.new(@mail, header, content, contents)
	end

	def run_before_parsing
		if @weblog != nil then
			@get_plugin = @weblog.get_get_plugin
		end
	end

	def header_alias()
		result = {}

		if @get_plugin != nil then
			result = result.merge(@get_plugin.header_alias)
		end

		return result
	end

	def run_after_parsing(request)
		@report = {}

		if @mail_sender != nil && @get_plugin != nil then
			result = @get_plugin.get(request)
			@report = @get_plugin.report.clone
			@report[:errors] = @get_plugin.errors
			@report[:warnings] = @get_plugin.warnings

			if result then
				content = nil
				if @report[:original_content] != nil then
					mode = 'wiki'
					content = @report[:original_content]
				elsif @report[:original_html_content] != nil then
					mode = 'html'
					content = @report[:original_html_content]
				else
					result = false
				end

				if result then
					(send_header, send_content) = @mail_parser.parse_content(content, {}, __parser_mode(mode))
					header_with_postid = __get_header_with_postid(send_header, request.header['postid'])
					@mail_sender.sendmail_as_command(
						"edit",
						@param,
						header_with_postid,
						send_content,
						@mail.from_address,
						@report[:attachments].clone.delete_if{|attachment| attachment == nil},
						mode,
						@report[:related_attachments].clone.delete_if{|related_attachment| related_attachment == nil})
				end
			end

			if !result then
send_content = <<"END_CONTENT"
ブログ記事の取得に失敗しました。
#{make_exception_contents(@get_plugin.errors, @get_plugin.warnings)}
END_CONTENT
				@mail_sender.sendmail_as_command("error", blogid, {}, send_content, @mail.from_address, [])
			end

			return result
		end

		return false
	end

	def __parser_mode(mode)
		case mode
		when 'wiki'
			return Mail2WeblogMailParserPlainTextType.new
		when 'html'
			return Mail2WeblogMailParserHtmlTextType.new
		end
	end

	def __get_header_with_postid(header, postid)
		result = ["postid", postid]

		if header.kind_of?(Hash) then
			header.each do |key, value|
				if key != 'postid' then
					result.push(key)
					result.push(value)
				end
			end
		elsif header.kind_of?(Array) then
			i = 0
			while i < header.size
				key   = header[i + 0]
				value = header[i + 1]
				if key != 'postid' then
					result.push(key)
					result.push(value)
				end

				i = i + 2
			end
		end

		return result
	end

end
