# coding: UTF-8

require 'net/pop'
require 'optparse'

#=メールを全て削除するツールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: deletemail.rb 523 2012-02-17 04:43:04Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# 引数を解析する
# デフォルト値を設定する
config = {'port' => 110, 'outdir' => 'dump'}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-h HOST', '--host HOST', '[必須]POP3サーバのホスト名を指定する。') {|host| config['host'] = host}
	opts.on('-p PORT', '--port PORT', '[任意]POP3サーバにアクセスする際のポート番号を指定する。指定しなかった場合は 110 をデフォルトとする。') {|port| config['port'] = port}
	opts.on('-u USERNAME', '--user USERNAME', '[必須]POP3サーバにアクセスする際のユーザ名を指定する。') {|username| config['username'] = username}
	opts.on('-w PASSWORD', '--pass PASSWORD', '[必須]POP3サーバにアクセスする際のパスワードを指定する。') {|password| config['password'] = password}
	opts.on('-o OUTDIR', '--outdir OUTDIR', '[任意]ダンプ結果の出力先フォルダを指定する。') {|outdir| config['outdir'] = outdir}

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['host', 'port', 'username', 'password']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

count = 0
first_time = Time.now
pop = Net::POP3.new(config['host'], config['port'])
pop.start(config['username'], config['password']) do
	pop.each_mail do |m|
		count = count + 1
		m.delete
		puts count
	end
end

puts "Deleted #{count} / #{Time.now - first_time} [mail/sec]"
