# coding: UTF-8

class MiniTestResult

	attr_reader :start_time
	attr_reader :finish_time

	def initialize(input, to_encoding = nil, from_encoding = nil)
		@to_encoding = to_encoding
		@from_encoding = from_encoding

		@start_time = nil
		@finish_time = nil
		@result = {}
		@valid = false

		input_io = nil
		close_requirement = false
		if input.kind_of?(IO) then
			input_io = input
		elsif input.kind_of?(String) then
			close_requirement = true
			if File.exist?(input) then
				input_io = open(input, 'rb')
			end
		end

		if input_io != nil then
			begin
				buffer = input_io.read
				if buffer =~ /^#{SYSTEM_OUTPUT_PREFIX}Start running tests \.\.\. \[(.+)\]$/ then
					@start_time = $1
				end
				if buffer =~ /^#{SYSTEM_OUTPUT_PREFIX}Finish running tests \.\.\. \[(.+)\]$/ then
					@finish_time = $1
				end

				while %r!^#{SYSTEM_OUTPUT_PREFIX}Start running ([^\s]+?) tests.+?^# Running tests:(.+?)^Finished tests in ([0-9]+\.[0-9]+)s, ([0-9]+\.[0-9]+) tests/s, ([0-9]+\.[0-9]+) assertions/s\.(.+?)^([0-9]+) tests, ([0-9]+) assertions, ([0-9]+) failures, ([0-9]+) errors, ([0-9]+) skips(.+)!m =~ buffer
					test_source = $1
					result_content = $2
					elapsed_time = $3
					elapsed_time_per_tests = $4
					elpased_time_per_assertions = $5
					error_content = $6
					number_of_tests = $7
					number_of_assertions = $8
					number_of_fails = $9
					number_of_errors = $10
					number_of_skips = $11
					buffer = $12

					while /^([^\s]+)#(test[^\s]+) [:=] (.*?)([0-9]+\.[0-9]+) s [:=] ([\.EF])(.+)/m =~ result_content
						test_cls = $1
						test_method = $2
						test_stdout = $3
						test_sec = $4
						test_result = $5
						result_content = $6

						__set_result(test_source, test_cls, test_method, 'stdout', (test_stdout == '' ? nil : test_stdout))
						__set_result(test_source, test_cls, test_method, 'sec', test_sec)
						__set_result(test_source, test_cls, test_method, 'result', test_result)
					end

					while error_content.length > 0
						(matched, test_cls, test_method, error_line, error_content) = __match_failure_or_error(error_content)
						if matched then
							__set_result(test_source, test_cls, test_method, 'error_line', error_line)

							if /(.+?)(^  [0-9]+\) (Failure|Error):\s+?(.+?)\(.+?\)( \[(.+?)\])?:.*^(.+))/m =~ error_content then
								__set_result(test_source, test_cls, test_method, 'error_report', $1)
								error_content = $2
							else
								__set_result(test_source, test_cls, test_method, 'error_report', error_content)
								break
							end
						else
							break
						end
					end
				end

				@valid = true
			ensure
				if close_requirement then
					input_io.close
				end
			end
		end
	end

	def valid?
		return @valid
	end

	def each_sources(&block)
		@result.keys.sort.each do |test_source|
			block.call(test_source)
		end
	end

	def each_classes(test_source, &block)
		if @result.has_key?(test_source) then
			@result[test_source].keys.sort.each do |test_cls|
				block.call(test_cls)
			end
		end
	end

	def each_methods(test_source, test_cls, &block)
		if @result.has_key?(test_source) then
			if @result[test_source].has_key?(test_cls) then
				@result[test_source][test_cls].keys.sort.each do |test_method|
					block.call(test_method)
				end
			end
		end
	end

	def size_of_classes(test_source)
		if @result[test_source] then
			return @result[test_source].size
		end

		return 0
	end

	def size_of_methods(test_source, test_cls)
		if @result.has_key?(test_source) then
			if test_cls != nil then
				if @result[test_source][test_cls] != nil then
					return @result[test_source][test_cls].size
				end
			else
				result = 0

				each_classes(test_source) do |test_cls|
					result = result + size_of_methods(test_source, test_cls)
				end

				return result
			end
		end

		return 0
	end

	def success_count_of_class(test_source, test_cls)
		result = 0

		each_classes(test_source) do |test_cls|
			each_methods(test_source, test_cls) do |test_method|
				if result(test_source, test_cls, test_method) == '.' then
					result = result + 1
				end
			end
		end

		return result
	end

	def fail_count_of_class(test_source, test_cls)
		result = 0

		each_classes(test_source) do |test_cls|
			each_methods(test_source, test_cls) do |test_method|
				if result(test_source, test_cls, test_method) != '.' then
					result = result + 1
				end
			end
		end

		return result
	end

	def has_stdout?(test_source, test_cls, test_method)
		return __has_result(test_source, test_cls, test_method, 'stdout')
	end

	def stdout(test_source, test_cls, test_method)
		return __encode(__get_result(test_source, test_cls, test_method, 'stdout', ''))
	end

	def has_error_report?(test_source, test_cls, test_method)
		return __has_result(test_source, test_cls, test_method, 'error_report')
	end

	def error_line(test_source, test_cls, test_method)
		return __get_result(test_source, test_cls, test_method, 'error_line', '')
	end

	def error_report(test_source, test_cls, test_method)
		return __encode(__get_result(test_source, test_cls, test_method, 'error_report', ''))
	end

	def sec(test_source, test_cls, test_method)
		return __get_result(test_source, test_cls, test_method, 'sec', '')
	end

	def success?(test_source, test_cls, test_method)
		if test_source != nil then
			if test_cls != nil then
				if test_method != nil then
					return result(test_source, test_cls, test_method) == '.'
				else
					each_methods(test_source, test_cls) do |test_method|
						if result(test_source, test_cls, test_method) != '.' then
							return false
						end
					end
				end
			else
				each_classes(test_source) do |test_cls|
					each_methods(test_source, test_cls) do |test_method|
						if result(test_source, test_cls, test_method) != '.' then
							return false
						end
					end
				end
			end
		else
			each_sources do |test_source|
				each_classes(test_source) do |test_cls|
					each_methods(test_source, test_cls) do |test_method|
						if result(test_source, test_cls, test_method) != '.' then
							return false
						end
					end
				end
			end
		end

		return true
	end

	def result(test_source, test_cls, test_method)
		return __get_result(test_source, test_cls, test_method, 'result', '')
	end

	def __has_result(test_source, test_cls, test_method, name)
		return __get_result(test_source, test_cls, test_method, name, nil) != nil
	end

	def __get_result(test_source, test_cls, test_method, name, default_value)
		if @result.has_key?(test_source) then
			if @result[test_source].has_key?(test_cls) then
				if @result[test_source][test_cls].has_key?(test_method) then
					return @result[test_source][test_cls][test_method][name]
				end
			end
		end

		return default_value
	end

	def __set_result(test_source, test_cls, test_method, name, value)
		test_source = test_source.strip
		test_cls = test_cls.strip
		test_method = test_method.strip
		name = name.strip

		if !@result.has_key?(test_source) then
			@result[test_source] = {}
		end

		if !@result[test_source].has_key?(test_cls) then
			@result[test_source][test_cls] = {}
		end

		if !@result[test_source][test_cls].has_key?(test_method) then
			@result[test_source][test_cls][test_method] = {}
		end

		@result[test_source][test_cls][test_method][name] = value
	end

	def __match_failure_or_error(error_content)
		if /^  [0-9]+\) Failure:\s+?(.+?)\((.+?)\) \[(.+?)\]:.*?^(.+)/m =~ error_content then
			return [true, $2, $1, $3, $4]
		end

		if /^  [0-9]+\) Error:\s+?(.+?)\((.+?)\):.*?^(.+)/m =~ error_content then
			return [true, $2, $1, nil, $3]
		end

		return [false, nil, nil, nil]
	end

	def __encode(content)
		if @to_encoding != nil then
			if @from_encoding != nil then
				return content.encode(@to_encoding, @from_encoding)
			else
				return content.encode(@to_encoding)
			end
		else
			return content
		end
	end

end
