# coding: UTF-8

require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

#=標準のブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_edit.rb 541 2012-02-23 01:23:52Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardEdit_WeblogPlugin < StandardCommand_WeblogPlugin

	def edit(original_content, header, content, contents, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#edit ... endpoint = #{@parent.endpoint}, header = #{header.to_s}")

		result = false

		client = @parent.client
		formatter = @parent.formatter
		postid = header['postid']

		if postid != nil then
			begin
				# 必要に応じてブログＩＤを変換する
				begin
					blogid = @parent.transform_blogid(blogid) if @parent.respond_to?('transform_blogid')
				rescue WeblogPluginError => e
					M2W_LOGGER.error(e)
					@errors.push(e)
					return false
				rescue WeblogPluginWarning => e
					M2W_LOGGER.error(e)
					@warnings.push(e)
				end

				before(client, header, content, attachments, blogid, postid, @errors, @warnings)

				vars = {:blogid => blogid, :postid => postid, :encoding => @parent.encoding, M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME]}
				vars.merge!(header)

				# 書式プラグインの事前処理を行う
				formatter.preset(
					original_content, content, contents, vars, @errors, @warnings)

				# 投稿日付を取得する
				dateCreated = @parent.parse_date(header['dateCreated'], Time.now, @errors, @warnings)
				if header['dateCreated'] != nil then
					header['dateCreated'] = @parent.get_date(dateCreated)
				end

				# 添付ファイルを投稿する
				begin
					(attachment_urls, thumbnail_urls) = post_medias(client, @parent.username, @parent.password, blogid, postid, header, vars, attachments, dateCreated, @errors, @warnings)
					vars[:attachment_urls] = attachment_urls
					vars[:thumbnail_urls] = thumbnail_urls
				rescue WeblogPluginWarning => warning
					vars[:attachment_urls] = []
					vars[:thumbnail_urls] = []
					warnings.push(warning)
				rescue WeblogPluginError => error
					vars[:attachment_urls] = []
					vars[:thumbnail_urls] = []
					errors.push(error)
				end


				# 書式変換を行う
				begin
					formatted_contents = nil
					formatted_contents = formatter.format(
						original_content, content, contents, vars, @errors, @warnings)
					header.merge!(formatted_contents)
				rescue => e
					M2W_LOGGER.error("ブログ記事の書式変換に失敗しました。")
					M2W_LOGGER.error(e)
					@errors.push(WeblogPluginError.new(
						"書式変換エラー(メッセージ = #{e.message})",
						"ブログ記事の書式変換に失敗しました(メッセージ = #{e.message})。"))
					M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = false")
					return false
				end

				# ブログ記事を編集投稿する
				begin
					edit_article(client, blogid, postid, header, dateCreated)
					@report[:original_content] = original_content
					@report[:postid] = postid
					@report[:attachment_urls] = {}
					@report[:thumbnail_urls] = {}
				rescue => e
					M2W_LOGGER.error("ブログ記事の編集に失敗しました。")
					M2W_LOGGER.error(e)
					@errors.push(WeblogPluginError.new(
						"ブログ記事投稿エラー(メッセージ = #{e.message})",
						"ブログ記事の投稿に失敗しました(メッセージ = #{e.message})。"))
				end

				@report[:original_content] = original_content
				@report[:postid] = postid.to_s
				@report[:attachment_urls] = attachment_urls
				@report[:thumbnail_urls] = thumbnail_urls
				@report[:title] = header['title']

				after(client, header, content, attachments, blogid, postid, @errors, @warnings)

				M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = true")
				return true
			rescue => e
				M2W_LOGGER.error("ブログ記事の編集に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"ブログ記事編集エラー(メッセージ = #{e.message})",
					"ブログ記事の編集に失敗しました(メッセージ = #{e.message})。"))
			end
		else
			M2W_LOGGER.error("投稿ＩＤの指定がありません。")
			@errors.push(WeblogPluginError.new(
				"投稿ＩＤ指定不足",
				"投稿ＩＤの指定がありませんでした。"))
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = false")
		return false
	end

	def header_alias
		return M2W_WEBLOG_POST_HEADER_ALIAS
	end

	def before(client, header, content, attachments, blogid, postid, errors, warnings)
	end

	def after(client, header, content, attachments, blogid, postid, errors, warnings)
	end

	def edit_article(client, blogid, postid, header, dateCreated)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

end
