# coding: UTF-8

require 'plugin/weblog/atom_pub/atom_pub_post'

#=はてなダイアリーのためのブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_post.rb 541 2012-02-23 01:23:52Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryPost_WeblogPlugin < AtomPubPost_WeblogPlugin

	def post_medias(client, username, password, blogid, postid, header, vars, attachments, dateCreated, errors, warnings)
		M2W_LOGGER.debug("Start  #{self.class.name}#post_medias ... header = #{header.to_s}, vars = #{vars.to_s}")
		if attachments != nil && attachments.size > 0 then
			attachments.each_with_index do |attachment, attachment_index|
				warnings.push(WeblogPluginError.new(
					"添付ファイル転送未対応(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
					"添付ファイルの転送に対応していません(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
			end
		end
		M2W_LOGGER.debug("Finish #{self.class.name}#post_medias")

		return [{}, {}]
	end

	def parse_postid(entry_uri)
		if %r!/(([0-9]+/)?[0-9]+)$! =~ entry_uri then
			return $1
		else
			return nil
		end
	end

	def after(client, header, content, attachments, blogid, postid, errors, warnings)
		super

		request_trackback(client, header, blogid)
	end

end
