# coding: UTF-8

require 'm2w_plugin_manager'
require 'plugin/weblog/meta_weblog/meta_weblog_post'
require 'style/formatter'
require 'xmlrpc_support/xmlrpc_writer'

require 'time'
require 'uri'

M2W_META_WEBLOG_DEFAULT_ENCODING = 'UTF-8'
M2W_META_WEBLOG_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_META_WEBLOG_THUMBNAIL_ROOT_PATH = 'thumbs'
M2W_META_WEBLOG_POST_HEADER_ALIAS = {
  'tit' => 'title',
  'dat' => 'dateCreated',
  'desc' => 'description',
  'more' => 'mt_text_more',
  'excerpt' => 'mt_excerpt',
}

#=metaWeblog API を使った標準のウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblog_WeblogPlugin

	attr_accessor :mail_parser
	attr_accessor :mail_sender
	attr_accessor :plugin_manager

	attr_reader :endpoint
	attr_reader :username
	attr_reader :password
	attr_reader :encoding
	attr_reader :attachment_root_path
	attr_reader :thumbnail_root_path
	attr_reader :default_blogid

	def initialize(
			endpoint = M2W_WEBLOG_ENDPOINT,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD,
			encoding = M2W_META_WEBLOG_DEFAULT_ENCODING,
			attachment_root_path = M2W_META_WEBLOG_ATTACHMENT_ROOT_PATH,
			thumbnail_root_path = M2W_META_WEBLOG_THUMBNAIL_ROOT_PATH,
			default_blogid = defined?(M2W_WEBLOG_DEFAULT_BLOGID) ? M2W_WEBLOG_DEFAULT_BLOGID : nil)
		@endpoint = endpoint
		@username = username
		@password = password
		@encoding = encoding
		@attachment_root_path = attachment_root_path
		@thumbnail_root_path = thumbnail_root_path
		@default_blogid = default_blogid
	end

	def client
		uri = URI.parse(@endpoint)
		result = XMLRPC::Client.new(uri.host, uri.path)
		if M2W_SYSTEM_COMMUNICATION_TIMEOUT != nil then
			result.timeout = M2W_SYSTEM_COMMUNICATION_TIMEOUT
		end
		# result.set_writer(XMLRPCWriter.new(M2W_SYSTEM_INNER_ENCODING))
		return result
	end

	def formatter
		return Formatter.new(@plugin_manager)
	end

	# 文字列を日付に直します。
	def parse_date(date_string, default_date, errors, warnings)
		begin
			if @plugin_manager != nil then
				return @plugin_manager.parse_weblog_date(date_string, default_date)
			elsif date_string != nil
				return Time.parse(date_string)
			end
		rescue ArgumentError => e
			M2W_LOGGER.error("ブログ投稿期日の指定が不正でうまく認識できませんでした(ブログ投稿期日指定 = #{date_string})。")
			M2W_LOGGER.error(e)
			warnings.push(WeblogPluginWarning.new(
				"ブログ投稿期日指定不正(ブログ投稿期日指定 = #{date_string})。",
				"ブログ投稿期日が解析できませんでした。指定は無視して投稿時日付と解釈します(ブログ投稿期日指定 = #{date_string})。"))
		end

		return default_date
	end

	# 日付を文字列に直します。
	def get_date(date)
		date = date.clone
		date.gmtime
		return "#{date.strftime('%Y%m%dT%H:%M:%S')}Z"
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# 添付ファイルのパスを取得します。
	def get_attachment_filepath(postid, dateCreated, attachment_index, attachment_filename)
		default = get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		if @plugin_manager != nil then
			return @plugin_manager.get_weblog_filepath('attachment_url', postid, dateCreated, attachment_index, attachment_filename, default)
		else
			return default
		end
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, thumbnail_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(thumbnail_filename)}"
	end

	# サムネイルのパスを取得します。
	def get_thumbnail_filepath(postid, dateCreated, attachment_index, attachment_filename)
		default = get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		if @plugin_manager != nil then
			return @plugin_manager.get_weblog_filepath('thumbnail_url', postid, dateCreated, attachment_index, attachment_filename, default)
		else
			return default
		end
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return MetaWeblogPost_WeblogPlugin.new(self)
	end

	# ブログ記事取得用のプラグインを取得します。
	def get_get_plugin()
		return MetaWeblogGet_WeblogPlugin.new(self)
	end

	# ブログ記事編集用のプラグインを取得します。
	def get_edit_plugin()
		return MetaWeblogEdit_WeblogPlugin.new(self)
	end

end
