# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__)) + "/../../m2w"

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'conf/setting'

require 'minitest/unit'

MiniTest::Unit.autorun

#=ニコニコ動画へのサムネイルを貼り付ける nico 書式プラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_nico_plugin.rb 205 2011-08-12 01:44:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestNicoFormatPlugin < MiniTest::Unit::TestCase

	if REAL_M2W_TEST then
		def test_plugin_contents
			plugin = Nico_FormatPlugin.new()

			result = plugin.plugin_contents('3794862', {})
			assert_match %r!<div><iframe.+?><a href.+?>.+?</a></iframe></div>!, result

			assert_raises(FormatPluginWarning) do
				plugin.plugin_contents('0', {})
			end
		end

		def test_plugin_contents_inline
			plugin = Nico_FormatPlugin.new()

			result = plugin.plugin_contents_inline('3794862', {})
			assert_match %r!<iframe.+?><a href.+?>.+?</a></iframe>!, result

			assert_raises(FormatPluginWarning) do
				plugin.plugin_contents_inline('0', {})
			end
		end
	end

end
