# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'

require 'minitest/unit'

MiniTest::Unit.autorun

#=Hash の deep_merge 拡張のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_deep_extension.rb 310 2011-09-29 00:38:00Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestHashExtension < MiniTest::Unit::TestCase

	def test_deep_merge
		source = {'a' => 'value1', 'b' => {'c' => 'value2', 'd' => {'e' => 'value3'}}}
		target = {'w' => 'value4', 'b' => {'x' => 'value5', 'y' => {'z' => 'value6'}}}

		result = source.deep_merge(target)
		assert_equal 'value1', result['a']
		assert_equal 'value2', result['b']['c']
		assert_equal 'value3', result['b']['d']['e']
		assert_equal 'value4', result['w']
		assert_equal 'value5', result['b']['x']
		assert_equal 'value6', result['b']['y']['z']
	end

	def test_deep_merge!
		source = {'a' => 'value1', 'b' => {'c' => 'value2', 'd' => {'e' => 'value3'}}}
		target = {'w' => 'value4', 'b' => {'x' => 'value5', 'y' => {'z' => 'value6'}}}

		source.deep_merge!(target)
		assert_equal 'value1', source['a']
		assert_equal 'value2', source['b']['c']
		assert_equal 'value3', source['b']['d']['e']
		assert_equal 'value4', source['w']
		assert_equal 'value5', source['b']['x']
		assert_equal 'value6', source['b']['y']['z']
	end

end
