# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../../")
$:.unshift(ROOT_PATH + "/../../../main/")
$:.unshift(ROOT_PATH + "/../../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../../main/"

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'conf/setting'
require 'mailutils/mail_processor'
require 'testutils/accessor'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require 'minitest/unit'

MiniTest::Unit.autorun

#=ブログ記事投稿コマンドプラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_post_plugin.rb 334 2011-10-14 12:42:16Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestPostCommandPlugin < MiniTest::Unit::TestCase

	if REAL_M2W_TEST && REAL_POST_TEST  then
		def setup
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})

			@mail_sender = Mail2WeblogMailSender.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS))

			@mail_testutils = MailTestUtils.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SYSTEM_INNER_ENCODING)
			@mail_testutils.delete_all()

			@weblog_testutils = WeblogTestUtils.new(
				@mail_parser,
				@mail_sender,
				@mail_testutils,
				SENDER_MAILADDRESS)
		end

		# リアル投稿テストです。
		# 本テストは、設定（conf/setting.rb）に依存します。
		def test_simple
			M2W_LOGGER.debug("Start  #{self.class.name}#test_simple")

			# コマンドを実行する
			from_address = MailAddress.new(SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(M2W_POP3_SERVER_ADDRESS)]
			keyword = Time.now.asctime
			title = "タイトルテスト@#{keyword}"
			attr1 = "属性１@#{keyword}"
			attr2 = "属性２@#{keyword}"
			message = "コンテンツテスト１行目@#{keyword}\n\nコンテンツテスト２行目@#{keyword}"
			content = @mail_sender.make_content(
				{
					'tit' => title,
					'attr1' => attr1,
					'attr2' => attr2,
				},
			message)
			mail = Mail.new("m.post.#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, [])
			command = Post_CommandPlugin.new
			command.weblog = M2W_WEBLOG_EXTENSION
			command.mail_parser = @mail_parser
			command.mail_sender = @mail_sender
			command.mail = mail
			command.param = WEBLOG_BLOG_ID
			assert command.run()
			assert command.report[:postid] != nil
			assert_nil command.report[:attachment_urls]

			# メールの受信を確認する
			mail = @mail_testutils.get_mail()
			assert mail != nil
			assert_equal "m.get.#{WEBLOG_BLOG_ID}", mail.subject
			assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
			assert_equal from_address.name, mail.from_address.name
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			assert_match /postid\.[1-9][0-9]*/, mail.content
			assert_equal 0, mail.attachments.size

			# ブログ記事を取得して内容を確認する
			(get_result, mail, header, content, attachments, link) = @weblog_testutils.get(WEBLOG_BLOG_ID, command.report[:postid])
			assert get_result
			assert_equal 3, header.size
			assert_equal title, header['tit']
			assert_equal attr1, header['attr1']
			assert_equal attr2, header['attr2']
			assert_equal message, content
			assert_equal 0, attachments.size

			# ブログ記事の投稿を確認する
			response = Accessor.access_url(link, WEBLOG_ENCODING).encode(M2W_SYSTEM_INNER_ENCODING)
			assert_match title, response
			assert_match %r!<p>.*コンテンツテスト１行目@#{keyword}(</p>.*<p>|<br><br>)コンテンツテスト２行目@#{keyword}.*</p>!m, response

			M2W_LOGGER.debug("Finish #{self.class.name}#test_simple")
		end

		if REAL_ATTACHMENTS_TEST then
			def test_attachments
				M2W_LOGGER.debug("Start  #{self.class.name}#test_attachments")

				# コマンドを実行する
				from_address = MailAddress.new(SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(RECEIVER_MAILADDRESS)]
				keyword = Time.now.asctime
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト\@#{keyword}"
				thumbnail_message = "{{img(3/thumb/s@50)}}"

				content = @mail_sender.make_content({"tit" => title}, message + thumbnail_message)
				attachments = [MailAttachment.new("test1.txt", "abc"), MailAttachment.new("test2.txt", "def"), MailProcessor.load_attachment("#{ROOT_PATH}/data/eyes0367.jpg")]
				mail = Mail.new("m.post.#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, attachments)
				command = Post_CommandPlugin.new
				command.weblog = M2W_WEBLOG_EXTENSION
				command.mail_parser = @mail_parser
				command.mail_sender = @mail_sender
				command.plugin_manager = Mail2WeblogPluginManager.new()
				command.mail = mail
				command.param = WEBLOG_BLOG_ID
				assert command.run()
				assert command.report[:postid] != nil
				assert command.report[:attachment_urls] != nil
				assert_equal 3, command.report[:attachment_urls].size

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal "m.get.#{WEBLOG_BLOG_ID}", mail.subject
				assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				assert_match /^postid\.[1-9][0-9]*/, mail.content
				assert_equal 0, mail.attachments.size

				# ブログ記事を取得して内容を確認する
				(get_result, mail, header, content, attachments, link) = @weblog_testutils.get(WEBLOG_BLOG_ID, command.report[:postid])
				assert get_result
				assert_equal 1, header.size
				assert_equal title, header["tit"]
				assert_equal message + thumbnail_message, content
				assert_equal 3, attachments.size

				# ブログの投稿を確認する
				response = Accessor.access_url(link, WEBLOG_ENCODING).encode(M2W_SYSTEM_INNER_ENCODING)
				assert_match title, response
				assert_match /<!--m2w_version:[0-9]{2}\.[0-9]{2}\.[0-9]{2}--><!--\[wikicontent\] .+? --><!--\[attachment_urls\] 1=.+? -->.+?#{message}.+?/m, response

				# 添付ファイルを確認する
				filepath = "#{M2W_WEBLOG_EXTENSION.get_attachment_filepath(command.report[:postid], Time.now, 1, attachments[0].filename)}".gsub(".", "\.")
				assert_match /#{filepath}$/, command.report[:attachment_urls][1]
				response = Accessor.access_url(command.report[:attachment_urls][1])
				assert_equal response, attachments[0].content
				filepath = "#{M2W_WEBLOG_EXTENSION.get_attachment_filepath(command.report[:postid], Time.now, 2, attachments[1].filename)}".gsub(".", "\.")
				assert_match /#{filepath}$/, command.report[:attachment_urls][2]
				response = Accessor.access_url(command.report[:attachment_urls][2])
				assert_equal response, attachments[1].content
				filepath = "#{M2W_WEBLOG_EXTENSION.get_attachment_filepath(command.report[:postid], Time.now, 3, attachments[2].filename)}".gsub(".", "\.")
				assert_match /#{filepath}$/, command.report[:attachment_urls][3]
				response = Accessor.access_url(command.report[:attachment_urls][3])
				assert_equal response, attachments[2].content
				if M2W_SYSTEM_RMAGICK_SUPPORTED then
					filepath = "#{M2W_WEBLOG_EXTENSION.get_thumbnail_filepath(command.report[:postid], Time.now, 3, attachments[2].filename)}".gsub(".", "\.")
					assert_match /#{filepath}$/, command.report[:thumbnail_urls][3]
					response = Accessor.access_url(command.report[:thumbnail_urls][3])
					thumbnail = Magick::Image.from_blob(attachments[2].content).shift.scale(0.5)
					assert_match response.split(':create', 2)[0], thumbnail.to_blob.split(':create', 2)[0]
				end

				M2W_LOGGER.debug("Finish #{self.class.name}#test_attachments")
			end
		end
	end

end
