# coding: UTF-8

require 'style/formatter'

require 'plugin/weblog/lib/weblog_plugin_warning'

M2W_WEBLOG_HATENA_DIARY_LINE_BREAK = "&amp;#10;"

#=本文のフォーマット変換を行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_formatter.rb 274 2011-09-19 07:32:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryFormatter < Formatter

	def preformat(content, content_with_header, has_attachments)
		@warnings = []
		@errors = []

		if has_attachments then
			@errors.push(WeblogPluginWarning.new("添付ファイル未対応", "添付ファイルを無視しました。"))
		end

		@commentout_content = get_commentout_content(content_with_header).encode(M2W_SYSTEM_INNER_ENCODING)
		return @commentout_content + content
	end

	def postformat(content, vars)
		raise WeblogPluginError.new("実装エラー", "実行されることのない処理が実行されました。")
	end

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\n/, M2W_WEBLOG_HATENA_DIARY_LINE_BREAK)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_HATENA_DIARY_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

end
