# coding: UTF-8

PERMISIBBLE_ERROR_FREQUENCY = 10

#=HTTP ANZT[
#
# ŏ̒:: gDC[
# |Wg:: $Id: accessor.rb 180 2011-08-09 18:18:40Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class Accessor

	def Accessor.separate_host_address(url)
		if %r!^http://(.+?)(/.*)$! =~ url then
			return [$1, $2]
		else
			return nil
		end
	end

	def Accessor.access_url(url, encoding = nil, permisibble_error_frequency = PERMISIBBLE_ERROR_FREQUENCY)
		(host, address) = Accessor.separate_host_address(url)
		return Accessor.access(host, address, encoding, permisibble_error_frequency)
	end

	def Accessor.access(host, address, encoding = nil, permisibble_error_frequency = PERMISIBBLE_ERROR_FREQUENCY)
		response = nil
		error_frequency = 0
		while response == nil
			begin
				Net::HTTP.start(host) do |http|
					response = http.get(address)
					case response
					when Net::HTTPSuccess
					else
						response = nil
					end
				end
			rescue Exception => eval
				puts "host = #{host}, address = #{address}, encoding = #{encoding}, permisibble_error_frequency = #{permisibble_error_frequency}"
				p eval
				error_frequency = error_frequency + 1

				if error_frequency >= permisibble_error_frequency then
					assert false
				end
			end
		end

		if encoding != nil then
			return response.body.encode(encoding, encoding)
		else
			return response.body
		end
	end

end
