# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../../")
$:.unshift(ROOT_PATH + "/../../../main/")
$:.unshift(ROOT_PATH + "/../../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../../main/"

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'conf/setting'
require 'mailutils/mail_processor'
require 'testutils/accessor'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require 'minitest/unit'

MiniTest::Unit.autorun

#=ブログ記事編集用コマンドプラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_edit_plugin.rb 228 2011-08-20 13:57:14Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestEditCommandPlugin < MiniTest::Unit::TestCase

	if REAL_M2W_TEST && REAL_EDIT_TEST then
		def setup
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})

			@mail_sender = Mail2WeblogMailSender.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS))

			@mail_testutils = MailTestUtils.new(
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SYSTEM_INNER_ENCODING)
			@mail_testutils.delete_all()

			@weblog_testutils = WeblogTestUtils.new(
				@mail_parser,
				@mail_sender,
				@mail_testutils,
				SENDER_MAILADDRESS)
		end

		# リアル投稿テストです。
		# 本テストは、設定（conf/setting.rb）に依存します。
		def test_simple
			M2W_LOGGER.debug("Start  #{self.class.name}#test_simple")

			# 期待値を設定する
			from_address = MailAddress.new(SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(M2W_POP3_SERVER_ADDRESS)]
			keyword = Time.now.asctime
			title = "タイトルテスト@#{keyword}"
			message = "コンテンツテスト１行目@#{keyword}\n\nコンテンツテスト２行目@#{keyword}"

			# 編集元のブログ記事を投稿する
			(post_result, mail, postid, attachment_urls) = @weblog_testutils.post(WEBLOG_BLOG_ID, {"tit" => title}, message)

			# コマンドを実行する
			title = "編集済みタイトルテスト@#{keyword}"
			message = "編集済みコンテンツテスト１行目@#{keyword}\n\n編集済みコンテンツテスト２行目@#{keyword}"
			content = @mail_sender.make_content({"tit" => title, "postid" => postid}, message)
			mail = Mail.new("m.edit.#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, [])
			command = Edit_CommandPlugin.new
			command.weblog = M2W_WEBLOG_EXTENSION
			command.mail_parser = @mail_parser
			command.mail_sender = @mail_sender
			command.mail = mail
			command.param = WEBLOG_BLOG_ID
			assert command.run()

			# メールの受信を確認する
			mail = @mail_testutils.get_mail()
			assert mail != nil
			assert_equal "m.get.#{WEBLOG_BLOG_ID}", mail.subject
			assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
			assert_equal from_address.name, mail.from_address.name
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			assert_match /^postid.#{postid}/, mail.content
			assert_equal 0, mail.attachments.size

			# ブログ記事を取得して内容を確認する
			(get_result, mail, header, content, attachments, link) = @weblog_testutils.get(WEBLOG_BLOG_ID, postid)
			assert get_result
			assert_equal 1, header.size
			assert_equal title, header["tit"]
			assert_equal message, content
			assert_equal 0, attachments.size

			# ブログ記事の投稿を確認する
			response = Accessor.access_url(link, WEBLOG_ENCODING).encode(M2W_SYSTEM_INNER_ENCODING)
			assert_match title, response
			assert_match %r!<p>.*編集済みコンテンツテスト１行目@#{keyword}(</p>.*<p>|<br><br>)編集済みコンテンツテスト２行目@#{keyword}.*</p>!m, response

			M2W_LOGGER.debug("Finish #{self.class.name}#test_simple")
		end

		if REAL_ATTACHMENTS_TEST then
			def test_attachments
				M2W_LOGGER.debug("Start  #{self.class.name}#test_simple")

				# 期待値を設定する
				from_address = MailAddress.new(SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(M2W_POP3_SERVER_ADDRESS)]
				keyword = Time.now.asctime
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト@#{keyword}"
				attachments = [MailAttachment.new("file1.txt", "value1"), MailAttachment.new("file2.txt", "value2")]

				# 編集元のブログ記事を投稿する
				(post_result, mail, postid, attachment_urls) = @weblog_testutils.post(WEBLOG_BLOG_ID, {"tit" => title}, message, attachments)

				# コマンドを実行する
				title = "編集済みタイトルテスト@#{keyword}"
				message = "編集済みコンテンツテスト@#{keyword}"
				content = @mail_sender.make_content({"tit" => title, "postid" => postid}, message)
				attachments = [MailAttachment.new("file1.txt", "value3"), MailAttachment.new("file2.txt", "value4")]
				mail = Mail.new("m.edit.#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, attachments)
				command = Edit_CommandPlugin.new
				command.weblog = M2W_WEBLOG_EXTENSION
				command.mail_parser = @mail_parser
				command.mail_sender = @mail_sender
				command.mail = mail
				command.param = WEBLOG_BLOG_ID
				assert command.run()

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal "m.get.#{WEBLOG_BLOG_ID}", mail.subject
				assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				assert_match /^postid.#{postid}/, mail.content
				assert_equal 0, mail.attachments.size

				# ブログ記事を取得して内容を確認する
				(get_result, mail, header, content, attachments, link) = @weblog_testutils.get(WEBLOG_BLOG_ID, postid)
				assert get_result
				assert_equal 1, header.size
				assert_equal title, header["tit"]
				assert_equal message, content
				assert_equal 2, attachments.size
				assert_equal "value3", attachments[0].content
				assert_equal "value4", attachments[1].content

				# ブログ記事の投稿を確認する
				response = Accessor.access_url(link, WEBLOG_ENCODING).encode(M2W_SYSTEM_INNER_ENCODING)
				assert_match title, response
				assert_match /<!--m2w_version:[0-9]{2}\.[0-9]{2}\.[0-9]{2}--><!--\[wikicontent\] .+? -->.+?#{message}.+?/m, response

				M2W_LOGGER.debug("Finish #{self.class.name}#test_simple")
			end
		end
	end

end
